% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{drug_prices_tbl_df}
\alias{drug_prices_tbl_df}
\title{Unit Drug Prices}
\format{
A tibble with 208 observations and 5 variables:
\describe{
  \item{description}{Character variable describing the drug or product}
  \item{currency}{Character variable indicating the currency in which the price is expressed}
  \item{cost}{Numeric variable indicating the unit cost of the drug}
  \item{unit}{Character variable representing the measurement unit (e.g., tablet, mL)}
  \item{parent_key}{Character variable serving as a linking identifier to related records}
}
}
\source{
Data taken from the covid19dbcand package version 0.1.1
}
\usage{
data(drug_prices_tbl_df)
}
\description{
This dataset, drug_prices_tbl_df, is a tibble containing information on unit prices
for various pharmaceutical products. Each record includes a description, currency,
cost per unit, unit type, and a parent key identifier.
}
\details{
The dataset name has been kept as 'drug_prices_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble data frame. The original content has not been modified
in any way.
}
