% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCountryCode.R
\name{getCountryCode}
\alias{getCountryCode}
\title{Return Country ISO Codes at Specified Locations}
\usage{
getCountryCode(lon, lat, dataset = "SimpleCountriesEEZ",
  countryCodes = NULL, allData = FALSE, useBuffering = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use}

\item{countryCodes}{vector of countryCodes}

\item{allData}{logical specifying whether a full dataframe should be returned}

\item{useBuffering}{logical flag specifying the use of location buffering to find the nearest polygon if no target polygon is found}
}
\value{
Vector of ISO-3166-1 alpha-2 country codes.
}
\description{
Uses spatial comparison to determine which country polygons the 
    locations fall into and returns the country code strings for those polygons.
    
    If \code{allData=TRUE}, additional data is returned.
}
\examples{
lon <- seq(0,50)
lat <- seq(0,50)
getCountryCode(lon,lat)
}
\references{
\url{http://www.naturalearthdata.com/downloads/10m-cultural-vectors/}
}
\seealso{
SimpleCountries

getSpatialData
}
\keyword{locator}
