% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift.R
\name{lift}
\alias{lift}
\alias{Lift}
\title{Model Lift}
\usage{
Lift(...)

lift(x, y = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{...}{named or unnamed \code{lift} output to combine together with the
\code{Lift} constructor.}

\item{x}{observed responses or \code{Resamples} object of observed and
predicted responses.}

\item{y}{predicted responses.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}
}
\value{
\code{Lift} class object that inherits from \code{Curves}.
}
\description{
Calculate lift estimates from observed and predicted responses.
}
\examples{
library(MASS)

res <- resample(type ~ ., data = Pima.tr, model = GBMModel)
lf <- lift(res)
plot(lf)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{plot}}
}
