% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{t.test}
\alias{t.test}
\alias{t.test.PerformanceDiff}
\title{Paired t-Tests for Model Comparisons}
\usage{
\method{t.test}{PerformanceDiff}(x, adjust = "holm", ...)
}
\arguments{
\item{x}{object containing paired differences between resampled metrics.}

\item{adjust}{p-value adjustment for multiple statistical comparisons as
implemented by \code{\link[stats]{p.adjust}}.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{HTestPerformanceDiff} class object that inherits from
\code{array}.  p-values and mean differences are contained in the lower and
upper triangular portions, respectively, of the first two dimensions.  Model
pairs are contined in the third dimension.
}
\description{
Paired t-test comparisons of resampled performance metrics from different
models.
}
\examples{
## Numeric response example
library(MASS)

fo <- medv ~ .
control <- CVControl()

gbmres1 <- resample(fo, Boston, GBMModel(n.trees = 25), control)
gbmres2 <- resample(fo, Boston, GBMModel(n.trees = 50), control)
gbmres3 <- resample(fo, Boston, GBMModel(n.trees = 100), control)

res <- Resamples(GBM1 = gbmres1, GBM2 = gbmres2, GBM3 = gbmres3)
perfdiff <- diff(res)
t.test(perfdiff)

}
\seealso{
\code{\link{diff}}
}
