% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.significance.list.compute.R
\name{perm.significance.list.compute}
\alias{perm.significance.list.compute}
\title{A Function for Creating a List of Pearson Correlation Coefficients}
\usage{
perm.significance.list.compute(exp.mat, cn.mat, gene.annot,
  sample.annot = NULL, method = "pearson", digits = 5, num.perms = 1000,
  random.seed = NULL, alternative = "greater")
}
\arguments{
\item{exp.mat}{A matrix of gene-level expression data (rows = genes, columns = samples).  Missing values are not permitted.}

\item{cn.mat}{A matrix of gene-level DNA copy number data (rows = genes, columns = samples).  Both genes and samples should
appear in the same order as exp.mat.  Missing values are not permitted.}

\item{gene.annot}{A three-column matrix containing gene position information.  Column 1 = chromosome number written in 
the form 'chr1' (note that chrX and chrY should be written chr23 and chr24), Column 2 = position (in base pairs), Column 3 = cytoband.
Genes should appear in the same order as exp.mat and cn.mat.}

\item{sample.annot}{An optional two-column matrix of sample annotation data.  Column 1 = sample IDs, Column 2 = sample annotation 
(e.g. tumor vs. normal).  If NULL, sample annot will be created using the common sample IDs and a single group ('1').  Default = NULL.}

\item{method}{A character string (either "pearson" or "spearman") specifying the method used to calculate the correlation coefficient
(default = "pearson").}

\item{digits}{Used with signif() to specify the number of significant digits (default = 5).}

\item{num.perms}{Number of permutations used to assess significance (default = 1e3).}

\item{random.seed}{Random seed (default = NULL).}

\item{alternative}{A character string ("greater" or "less") that specifies the direction of the alternative hypothesis, 
either rho > 0 or rho < 0 (default = "greater").}
}
\value{
Returns a list whose length is the number of unique groups defined by sample.annot.  Each entry in the list is the
output of perm.significance.
}
\description{
This function uses the corr.compute() function to compute gene-specific Pearson correlation coefficients in each
group of samples defined in a sample annotation matrix.
}
\examples{
exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 genes = c("MYEOV", "CCND1", "ORAOV1", "FGF19", "FGF4", "FGF3", "ANO1", "PPFIA1")

 pd = data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE, gene.list = genes)

 pd.exp = pd[["exp"]]

 pd.cn = pd[["cn"]]

 pd.ga = pd[["gene.annot"]]

 pd.sa = pd[["sample.annot"]]

 perm.significance.list.compute(pd.exp, pd.cn, pd.ga, pd.sa)

}
