% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxM.R
\name{BoxM}
\alias{BoxM}
\title{Box's M Test}
\usage{
BoxM(data, group)
}
\arguments{
\item{data}{a data frame.}

\item{group}{grouping vector.}
}
\value{
a list with 3 elements:
\item{ChiSquare}{The value of Test Statistic}
\item{df}{The Chi-Square statistic's degree of freedom}
\item{p.value}{p value}
}
\description{
\code{BoxM} function tests whether the covariance matrices of independent 
samples are equal or not.
}
\details{
This function computes  Box-M test statistic for the covariance matrices of independent samples.  
The hypotheses are defined as H0:The Covariance matrices are homogeneous and 
H1:The Covariance matrices are not homogeneous
}
\examples{

data(iris) 
results <- BoxM(data=iris[,1:4],group=iris[,5])
summary(results)
}
\references{
Rencher, A. C. (2003). Methods of multivariate analysis (Vol. 492). John Wiley & Sons.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
