% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf.R
\name{pdf}
\alias{pdf}
\title{Probability density function.}
\usage{
pdf(object, x, theta, y, log = FALSE, do.its = FALSE)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT}
created with \code{\link{fit.bayes}}.}

\item{x}{Vector (of size N) of point at \code{t = T + 1} to be evaluated (used when \code{do.its = FALSE}).}

\item{theta}{Vector (of size d) or matrix (of size M x d) of parameter estimates (not require when using a fit object).}

\item{y}{Vector (of size T) of observations (not require when using a fit object).}

\item{log}{Boolean indicating if the log-density is returned. (Default: \code{log = FALSE})}

\item{do.its}{Boolean indicating if the in-sample pdf is returned. (Default: \code{do.its = FALSE})}
}
\value{
A list of class \code{MSGARCH_PDF} containing two components:
\itemize{
\item \code{pdf}:\cr If \code{do.its = FALSE}: (Log-)Probability density of the points \code{x} at \code{t = T + 1} (vector of size N or matrix of size M x N) \cr
                  If \code{do.its = TRUE}: In-sample (Log-)Probability density of \code{y} (vector of size T or matrix of size M x T). 
\item \code{x}:\cr If \code{do.its = FALSE}: Vector (of size N) of point at \code{t = T + 1} evaluated.\cr
                If \code{do.its = TRUE}: Vector (of size T) of observations.
}
The class \code{MSGARCH_PDF} contains the \code{plot} method only if \code{do.its = FALSE}.
}
\description{
Method returning the probability density in-sample or of a vector of points at \code{t = T + 1}.
}
\details{
If a matrix of parameter estimates is given, each parameter estimates is evaluated individually. 
If \code{do.its = FALSE}, the points \code{x} are evaluated as \code{t = T + 1} realization and the method uses the variance estimate at \code{t = T + 1}.
If \code{do.its = TRUE}, \code{y} is evaluated using their respective variance estimate at each time \code{t}.
}
\examples{
# load data
data("sp500")
sp500 = sp500[1:1000]

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500, ctr = list(do.init = FALSE))

# run pdf method in-sample
pdf.its = MSGARCH::pdf(object = fit, log = FALSE, do.its = TRUE)

sum(pdf.its$pdf, na.rm = TRUE)
# create mesh

x = seq(-3,3,0.01)

# run pdf method on mesh at T + 1
pdf = MSGARCH::pdf(object = fit, x = x, log = FALSE, do.its = FALSE)

plot(pdf)
}

