% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmat.R
\name{transmat}
\alias{transmat}
\title{Transition Matrix.}
\usage{
transmat(object, theta, n)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}}.}

\item{theta}{Vector (of size d) of parameter estimates (not require when using a fit object).}

\item{n}{Number of steps ahead. (Default: \code{n = 1}}
}
\value{
A matrix (of size K x K) in the case of a Markov-Switching model
 or a vector (of size K) in the case of a Mixture model. 
 The columns indcates the starting states while the rows indicates the transition states.
}
\description{
Method returning the transition matrix.
}
\examples{
# load data
data("sp500")
sp500 = sp500[1:1000]

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500, ctr = list(do.init = FALSE))

# Extract the transition matrix 10 steps ahead
transmat.mle = MSGARCH::transmat(fit, n = 10)

print(transmat.mle)
}

