% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_scope.R
\name{SRA_scope}
\alias{SRA_scope}
\alias{plot_SRA_scope}
\title{Stock-reduction analysis (SRA) for conditioning operating models}
\usage{
SRA_scope(OM, Chist, Index = NULL, I_sd = NULL, CAA = NULL,
  CAL = NULL, ML = NULL, length_bin = NULL, C_eq = 0,
  ML_sd = NULL, selectivity = "logistic", I_type = NULL,
  LWT = list(), ESS = c(30, 30), cores = 1L, integrate = FALSE,
  figure = TRUE, Year = NULL, report = FALSE)

plot_SRA_scope(OM, Chist, Index = matrix(NA, 0, 0), CAA = NA,
  CAL = NA, ML = NA, report_list, Year = NULL)
}
\arguments{
\item{OM}{An object of class \linkS4class{OM} that specifies natural mortality (M), growth (Linf, K, t0, a, b), stock-recruitment relationship,
steepness, maturity parameters (L50 and L50_95), standard deviation of recruitment variability (Perr), as well as index uncertainty (Iobs).}

\item{Chist}{A vector of historical catch, should be of length OM@nyears. If there are multiple fleets: a matrix of OM@nyears rows and nfleet columns.
Ideally, the first year of the catch series represents unfished conditions (see also \code{C_eq}).}

\item{Index}{A vector of values of an index (of length OM@nyears). If there are multiple surveys: a matrix of historical indices of abundances, with rows
indexing years and columns indexing surveys.}

\item{I_sd}{A vector or matrix of standard deviations (lognormal distribution) for the indices corresponding to the entries in \code{Index}.
If NULL, this function will use values from OM@Iobs.}

\item{CAA}{Age composition matrix with nyears rows and OM@maxage columns. If multiple fleets: an array with dimension: nyears, OM@maxage, and nfleets.}

\item{CAL}{Length composition matrix with nyears rows and columns indexing the length bin. If multiple fleets: an array with dimension: nyears,
length bins, and nfleets.}

\item{ML}{A vector of mean length observations (length OM@nyears), or if multiple fleets: matrix of dimension: nyears and nfleets. Generally, should not
be used if \code{CAL} is also provided, unless mean length and length comps are independently sampled.}

\item{length_bin}{A vector for the midpoints of the length bins for \code{CAL}. All length bin widths should be equal in size.}

\item{C_eq}{A numeric vector of length nfleet for the equilibrium catch for each fleet in \code{Chist} prior to the first year of the operating model.
Zero implies unfished conditions in year one. Otherwise, this is used would estimate depletion in the first year of the data.}

\item{ML_sd}{The standard deviation (normal distribution) of the observed mean lengths. If there are multiple fleets, a vector of length nfleet.
If \code{NULL}, default value is 0.1.}

\item{selectivity}{A character vector of length nfleet to indicate \code{"logistic"} or \code{"dome"} selectivity for each fleet in \code{Chist}.}

\item{I_type}{A character vector (length nsurvey) to indicate the type of biomass for which each index follows. Either \code{"B"} for
total biomass, or \code{"SSB"} for spawning biomass. If \code{NULL}, "B" is used. Use numbers if the index corresponds to a fleet in \code{Chist}.}

\item{LWT}{A named list of likelihood weights for the SRA model. See details.}

\item{ESS}{A numeric vector of length two for the maximum effective samples size of the age and length compositions, respectively for the
multinomial likelihood function. The annual sample size of an age or length composition sample is the minimum of ESS or the number of observations.}

\item{cores}{Integer for the number of CPU cores for the stock reduction analysis.}

\item{integrate}{Logical, whether to treat recruitment deviations as penalized parameters (FALSE) or random effects (TRUE).}

\item{figure}{Logical, whether to plot diagnostic figures (histograms of estimated depletion and unfished recruitment, SRA outputs, model fits, etc.).}

\item{Year}{A vector of years for the historical period, used for plotting.}

\item{report}{Logical, whether to return all assessment output. See value section below.}

\item{report_list}{The list of assessment output returned by \code{SRA_scope} when \code{report = TRUE}.}
}
\value{
A named list containing the following:
\enumerate{
\item "OM" - an updated operating model with depletion, F, selectivity, and recruitment deviations from the SRA fits.
\item "output" - A list of output, e.g. spawning biomass and predicted catch at age, from the SRA fits:

\itemize{
\item SSB - A matrix of \code{OM@nsim} rows and \code{OM@nyears+1} columns for estimated spawning biomass
\item N - An array of dimension \code{c(nsim, nyears+1, maxage)} for estimated abundance by simulation, year, and age.
\item CAA - An array of dimension \code{c(nsim, nyears+1, maxage, and nfleet)} for estimated catch at age by simulation, year, age, and fleet.
\item CAL - An array of dimension \code{c(nsim, nyears+1, maxage, and nfleet)} for estimated catch at length by simulation, year, length bin, and fleet.
\item conv - A logical vector of length nsim indicating convergence of the SRA in the i-th simulation.
}

\item "report" - If \code{report = TRUE}, a list of length \code{OM@nsim} containing all the assessment output from each model fit, otherwise returns NULL.
Less organized than "output".
}
If \code{figure = TRUE}, a set of diagnostic plots for the fits to the SRA for each simulation as well histograms of operating model parameters,
e.g., depletion.
}
\description{
Intended for conditioning operating models for data-limited stocks. From a historical time series of total catch, and potentially
age/length compositions and multiple indices of abundance, the SRA returns a range of values for depletion, selectivity,
unfished recruitment (R0), historical fishing effort, and recruitment deviations for the operating model. This is done by sampling life history parameters
provided by the user and fitting to the data in a statistical catch-at-age model (with the predicted catch equal to the observed catch).
This function is intended to generate a range of potential depletion scenarios that could be supported from sparse data. A full catch time series
is needed but missing data (as NAs) are allowed for all other data types.
}
\details{
\code{plot_SRA_scope} generates the plots from the SRA scope function.

One of indices, age compositions, or length compositions should be provided in addition to the historical catch.
Selectivity is fixed to values sampled from \code{OM} if no age or length compositions are provided.

\code{LWT} is a named list containing the likelihood weights (values > 0) with the possible options:
\itemize{
\item Chist: A vector of length nfleet.
\item Index: A vector of length nsurvey.
\item CAA, CAL, ML, C_eq: A vector of length nfleet for each.
}
By default, all likelihood weights are equal to one if not specified by the user. Likelihoods for CAA and CAL can also be adjusted by changing the
multinomial sample size. See argument \code{ESS}.
}
\note{
If the operating model \code{OM} uses time-varying growth or M, then those trends will be used in the SRA as well.
Time-varying life history parameters create ambiguity in the calculation and interpretation of depletion and reference points in \link[DLMtool]{runMSE}.
See section D.5 of \code{DLMtool::userguide()}.

Here, the initial depletion (OM@cpars$initD) is calculated based on unfished spawning biomass using growth and M in the first year.

The easiest way to turn off time-varying growth/M is by setting: \code{OM@Msd <- OM@Linfsd <- OM@Ksd <- c(0, 0)}.
}
\author{
Q. Huynh
}
