% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NANUQ.R
\name{nexusDist}
\alias{nexusDist}
\title{Write a distance table to a file in nexus format}
\usage{
nexusDist(distMatrix, outfilename)
}
\arguments{
\item{distMatrix}{a square matrix giving a distance table, with rows and columns labeled by taxon names}

\item{outfilename}{the name of an output file}
}
\description{
Write a distance table to a file in nexus format.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
DQT=quartetTableDominant(RQT)
Dist=quartetDist(DQT)
nexusDist(Dist,outfile = file.path(tempdir(), "NANUQdist"))

}
