\name{constSweave}
\title{Constructor for Sweave report}
\alias{constSweave}
\description{
Construct a Sweave report that includes plots generated by the \code{\link{multiplot}} function.
}
\usage{
constSweave(dir,identifier=NULL,param=NULL,table=NULL,extra_text=NULL,
         subsection=NULL,index_subsection=NULL,subsubsection=NULL,
         index_subsubsection=NULL,legend=NULL,trace=TRUE,width=list(0.9,0.9,0.9),
         trim=list(c(0,0,0,0),c(0,0,0,0),c(0,160,0,0)),width.legend=0.35,
         trim.legend=c(0,0,0,0),title="",date="",author="")
}
\arguments{
  \item{dir}{the path to the root(s) directory(ies) containing the image files. \emph{character} or \emph{character vector}. REQUIRED.}
  \item{identifier}{the identifiers of the patients for which the graphics should be displayed. \emph{character vector} or \code{NULL} leading to use all patients.}
  \item{param}{the names of directories containing the images. \emph{character vector} or \code{NULL} leading to use all directories.}
  \item{table}{a list of data.frame to display in the table format. \emph{list of data.frame} or \code{NULL} if there is no table to display.}
  \item{extra_text}{additionnal text to display. \emph{list of character vector} or \code{NULL} if there is no extra text to display.}
    
  \item{subsection}{the names of subsections for the latex document. \emph{character vector} or \code{NULL} leading to use \code{param} for naming the subsections.}
  \item{index_subsection}{the position of the images in the subsections. \emph{numeric vector} or \code{NULL} leading to use a subsection for each image.}
   
  \item{subsubsection}{A list containing the names of the subsubsections for the latex document. \emph{list of character vector} or \code{NULL} leading to no subsubsection.}
  \item{index_subsubsection}{A list of positions of the images in the subsubsections. \emph{list of numeric vector} or \code{NULL}.}
    
  \item{legend}{the legend of each image. \emph{character vector} or \code{NULL} leading to use \code{param} for the legend.}
  \item{trace}{should the execution of the function be traced ? \emph{logical}.}
  \item{width}{the width of each image relative to the linewidth. \emph{list of positive numeric}.}
  \item{trim}{the length in mm with which the imported images will be cropped (left, bottom, right top). \emph{list of numeric vector of size 4}.}
    
  \item{width.legend}{the width of the legend image relative to the linewidth. \emph{numeric between 0 and 1}.}
  \item{trim.legend}{the length in mm with which the legend of the images will be cropped. \emph{numeric vector of size 4}.}
    
  \item{title}{the title of the latex document. \emph{character}.}
  \item{date}{the date on the latex document. \emph{character}.}
  \item{author}{the author of the latex document. \emph{character}.}
}
\details{
ARGUMENTS: \cr
\code{table} must contains in its first column the patient identifiers. This column will not be display. 

The \code{width} argument must be a \emph{list} containing the width used to display each image file.
For instance if \code{width=list(0.9,0.9,0.9)} the first image file (slices 1 to 9) will be display with a width of \code{0.9*linewidth}, as well as the second and third image file.

\code{index_subsubsection} has to be modified if subsubsections are defined by the user.

FUNCTION: \cr
Patient identifiers are read from the file names : it is the character string preceding the first underscore (\code{"_"}).

The function generate latex code that reads the images using the \code{includegraphicx} latex function. 
In particular arguments \code{width}, \code{trim}, \code{width.legend} and \code{trim.legend} are used by this function to adjust the display of the images.
}
\value{
  A \emph{list} containing :
  \itemize{
  \item\code{[[text.preamble]]} : a \emph{character} containing the preamble of a latex document.
  \item\code{[[text.begin]]} : a \emph{character} for beginning the latex report.
  \item\code{[[ls.text]]} : a \emph{list of character}, each containing the content of the report for each patient.
  \item\code{[[text.end]]} :  a \emph{character} for ending the latex report.
  \item\code{[[ls.plot]]} : a \emph{list} containing how the plots has been managed.
  \item\code{[[ls.legend]]} : a \emph{list} containing how the legends has been managed.
  \item\code{[[ls.newplot]]} : a \emph{list} containing how the figures has been managed.
  }
}

\examples{
\dontrun{
## load a MRIaggr object
data("MRIaggr.Pat1_red", package="MRIaggr")

## directories for storage
if(("Display" \%in\% list.files())  == FALSE){dir.create("Display")}
if(("DWI" \%in\% list.files("Display"))  == FALSE){dir.create("Display/DWI")}
if(("DWI_lesion" \%in\% list.files("Display"))  == FALSE){dir.create("Display/DWI_lesion")}
if(("T2" \%in\% list.files("Display"))  == FALSE){dir.create("Display/T2")}

## plot generation
multiplot(MRIaggr.Pat1_red,param="DWI_t0",
             window="png",path="Display/DWI/")
multiplot(MRIaggr.Pat1_red,param="DWI_t0",
             index1=list(coords="MASK_T2_FLAIR_t2",outline=TRUE),as.logical=TRUE,
             window="png",path="Display/DWI_lesion/")
multiplot(MRIaggr.Pat1_red,param="T2_FLAIR_t2",
             window="png",path="Display/T2/")

MRIaggr.Pat1_red@identifier <- "Pat2"

multiplot(MRIaggr.Pat1_red,param="DWI_t0",
             window="png",path="Display/DWI/")
multiplot(MRIaggr.Pat1_red,param="DWI_t0",
             index1=list(coords="MASK_T2_FLAIR_t2",outline=TRUE),as.logical=TRUE,
             window="png",path="Display/DWI_lesion/")
multiplot(MRIaggr.Pat1_red,param="T2_FLAIR_t2",
             window="png",path="Display/T2/")

## Sweave generation
tablePat <- list(cbind(Id0=MRIaggr.Pat1_red@identifier,
                    selectClinic(MRIaggr.Pat1_red,param=c("Age","Gender"))),
      cbind(Id0=MRIaggr.Pat1_red@identifier,
            selectClinic(MRIaggr.Pat1_red,param=c("FinalStroke_volume","AcuteStroke_volume")))
)

res <- constSweave(dir="Display",
                   table=tablePat)

cat(res$ls.text[[1]],sep="")

#### Sweave doc ########################
# <<label=test,results=tex,echo=FALSE>>=
#  require(MRIaggr)
#
#### Sweave generation
# data("MRIaggr.Pat1_red", package="MRIaggr")
#
# 
# tablePat <- list(cbind(Id0=MRIaggr.Pat1_red@identifier,
#                     selectClinic(MRIaggr.Pat1_red,param=c("Age","Gender"))),
#     cbind(Id0=MRIaggr.Pat1_red@identifier,
#           selectClinic(MRIaggr.Pat1_red,param=c("FinalStroke_volume","AcuteStroke_volume")))
# )
#
# extra_text <- c("blablabla \\n \\n",
#                "\\\bigskip \\n \\n",
#                "blablabla \\n \\n",
#                "\\\[Y = \\\beta X + \\\varepsilon \\\] \\n \\n"
# )
# legend <- list("DWI alone","DWI with clinician segmentation","final contrast")
# 
# res <- constSweave(dir="Display",
#                    extra_text=list(extra_text,extra_text),
#                    table=tablePat)
#
#
#### preamble
# cat(res$text.preamble,sep="")
#
#### document 
# cat(res$text.begin,sep="") 
#
#
#
# for(iter_list in 1:length(res$ls.text)){
#   cat(res$ls.text[[iter_list]],sep="")
# }
#
#  cat(res$text.end,sep="")
# @
########################################
}
}
\concept{const.}
\keyword{functions,Sweave}

