% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fssgeo.R
\name{fssgeo}
\alias{fssgeo}
\title{Function that creates an sf-object from IFS data}
\usage{
fssgeo(ifs, crsOut = 3035, locAdj = FALSE)
}
\arguments{
\item{ifs}{A data.frame or tibble with the locations and the data of the survey or census data}

\item{crsOut}{The coordinate reference system (crs) to be used}

\item{locAdj}{parameter to adjust the coordinates if they are exactly on the borders between grid cells. The values
can either be FALSE, or "jitter" (adding a small random value to the coordinates, essentially spreading
them randomly around the real location), "UR", "UL", "LR" or "LL", to describe which corner of the grid 
cell the location belong (upper right, upper left, lower right or lower left).}
}
\value{
An \code{\link[sf]{sf}}-object with the locations of the survey or census data
}
\description{
Function that creates an sf-object from IFS data
}
\details{
The geo-location in the FSS file has a particular format. For 2020, it includes country, coordinate reference system (CRS), resolution
(precision of coordinates) and coordinates
in one attribute ("GEO_LCT"). For past years, the FSS data structure differs and it includes three separate columns, like latitudes, longitudes and coordinate reference system.
This function splits the attribute in its individual parts, and creates an
sf-object with the correct coordinates and CRS.
}
\examples{
data(ifs_dk)
ifg = fssgeo(ifs_dk)


}
