% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_batch_subset.R
\name{mt_batch_subset}
\alias{mt_batch_subset}
\title{Batch download MODIS Land Products subsets}
\usage{
mt_batch_subset(
  df,
  product,
  band,
  start = "2000-01-01",
  end = format(Sys.time(), "\%Y-\%m-\%d"),
  km_lr = 0,
  km_ab = 0,
  out_dir = tempdir(),
  internal = TRUE
)
}
\arguments{
\item{df}{a CSV file or data frame holding locations and their sitenames to
batch process with column names site_name, lat, lon holding the respective
sitenames, latitude and longitude. When providing a CSV make sure that the
data are comma separated.}

\item{product}{a valid MODIS product name}

\item{band}{band to download}

\item{start}{start date}

\item{end}{end date}

\item{km_lr}{km left-right to sample}

\item{km_ab}{km above-below to sample}

\item{out_dir}{location where to store all data}

\item{internal}{should the data be returned as an internal data structure
\code{TRUE} or \code{FALSE} (default = \code{TRUE})}
}
\value{
A data frame combining meta-data and actual data values, data from
different sites is concatenated into one large dataframe. Subsets can be
created by searching on sitename.
}
\description{
Lists all available dates for a MODIS Land Products Subset product
at a particular location.
}
\examples{

\dontrun{
# create data frame with a site_name, lat and lon column
# holding the respective names of sites and their location
df <- data.frame("site_name" = paste("test",1:2))
df$lat <- 40
df$lon <- -110

print(df)

# test batch download
subsets <- mt_batch_subset(df = df,
                        product = "MOD11A2",
                        band = "LST_Day_1km",
                        internal = TRUE,
                        start = "2004-01-01",
                        end = "2004-03-31")

# the same can be done using a CSV file with
# a data structure similar to the dataframe above

write.table(df, file.path(tempdir(),"my_sites.csv"),
 quote = FALSE,
 row.names = FALSE,
 col.names = TRUE,
 sep = ",")

# test batch download form CSV
subsets <- mt_batch_subset(df = file.path(tempdir(),"my_sites.csv"),
                        product = "MOD11A2",
                        band = "LST_Day_1km",
                        internal = TRUE,
                        start = "2004-01-01",
                        end = "2004-03-31"
                        )

head(subsets)
}
}
\seealso{
\code{\link[MODISTools]{mt_sites}}
\code{\link[MODISTools]{mt_dates}} \code{\link[MODISTools]{mt_bands}}
\code{\link[MODISTools]{mt_products}}
\code{\link[MODISTools]{mt_subset}}
}
