% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSds.R
\name{getSds}
\alias{getSds}
\title{List SDS Layers in an \code{.HDF} File}
\usage{
getSds(HdfName, SDSstring = NULL, ...)
}
\arguments{
\item{HdfName}{\code{character}. (Absolute) filename from which to extract 
SDS names. Non-existing files are being looked up recursively in 
\code{getOption("MODIS_localArcPath")}.}

\item{SDSstring}{An optional \code{character} string of 1s and 0s, see Value.}

\item{...}{Currently not used.}
}
\value{
A \code{list}. If \code{SDSstring} is provided, the function reports matching 
SDS and a formatted 'SDSstring' (e.g., "1 1 1 0 1"). If omitted, the names of 
all SDS in 'HdfName' are returned.
}
\description{
List the names of all scientific datasets (SDS) contained in a specified 
MODIS grid HDF file.
}
\examples{
\dontrun{
getSds(HdfName="/path/XXX.hdf")
# example w/'SDSstring' 
}

}
\author{
Matteo Mattiuzzi, Florian Detsch
}
