% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMWRweek.R
\name{MMWRweek}
\alias{MMWRweek}
\title{MMWR day, week, and year}
\usage{
MMWRweek(date)
}
\arguments{
\item{date}{vector which can be coerced to class \code{Date}}
}
\value{
data.frame with elements MMWRday (of the week), MMWRweek, and MMWRyear
}
\description{
This function returns the MMWR day, week, and year for the Date(s) provided.
}
\details{
The first day of any MMWR week is Sunday. MMWR week numbering is sequential 
beginning with 1 and incrementing with each week to a maximum of 52 or 53. 
MMWR week #1 of an MMWR year is the first week of the year that has at least 
four days in the calendar year. For example, if January 1 occurs on a Sunday, 
Monday, Tuesday or Wednesday, the calendar week that includes January 1 would 
be MMWR week #1. If January 1 occurs on a Thursday, Friday, or Saturday, the 
calendar week that includes January 1 would be the last MMWR week of the previous 
year (#52 or #53). Because of this rule, December 29, 30, and 31 could potentially 
fall into MMWR week #1 of the following MMWR year.
}
\examples{
y = as.Date(paste(1999:2011, "-12-31", sep = ""))
cbind(y, MMWRweek(y))
}
\author{
Jarad Niemi \email{niemi@iastate.edu}
}
\references{
\url{http://wwwn.cdc.gov/nndss/document/MMWR_Week_overview.pdf}
}
\seealso{
\code{\link{MMWRweekday}}, \code{\link{MMWRweek2Date}}
}

