% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateData}
\alias{generateData}
\title{Generate random mixture multinomial dataset}
\usage{
generateData(n, p, d, m, k, theta = rdirichlet(1, rep(1, k)),
  psi = array(rdirichlet(k * p, rep(1, d)), dim = c(k, p, d)), miss = 0)
}
\arguments{
\item{n}{- number of observations}

\item{p}{- number of variables}

\item{d}{- number of categories}

\item{m}{- number of trials}

\item{k}{- number of components}

\item{theta}{- a vector that sum to 1, denotes probability of latent components. Default value is Dirichlet random number with equal weight.}

\item{psi}{- an array with dimension c(k,p,d), specific probability for each variables in each component. Default value is Dirichlet random number with equal weight.}

\item{miss}{- rate of missing data in all observations. Missing mechanism is Missing Completely At Random (MCAR). The value of miss is from 0 to 1. Default value is 0. Missing data is denoted by NA.
Here assume all trials in data[i,j,] are missing or observed at the same time.}
}
\value{
data - random dataset generated.

theta - values of theta are used to generate random dataset.

psi - values of psi are used to generate random dataset.
}
\description{
This function is used to generate random mixture multinomial dataset. It helps to evaluate our estimatior.
}
\examples{
n<-100; k<-2; d<-2; m<-10; p<-2;
completedata<-generateData(n,p,d,m,k)
incompletedata<-generateData(n,p,d,m,k,miss = 0.25)
}

