% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{AUC}
\alias{AUC}
\title{Area Under the Curve (AUC)}
\usage{
AUC(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) 0-1 labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}
}
\value{
Area Under the Curve (AUC)
}
\description{
Compute the Area Under the Curve (AUC) from prediction scores.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
AUC(y_true=mtcars$vs, y_pred=logreg$fitted.values)
}

