% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stability.MLGL}
\alias{stability.MLGL}
\title{Stability Selection for Multi-Layer Group-lasso}
\usage{
stability.MLGL(X, y, B = 50, fraction = 0.5, hc = NULL,
  lambda = NULL, weightLevel = NULL, weightSizeGroup = NULL,
  loss = c("ls", "logit"), intercept = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{X}{matrix of size n*p}

\item{y}{vector of size n. If loss = "logit", elements of y must be in {-1,1}}

\item{B}{number of bootstrap sample}

\item{fraction}{Fraction of data used at each of the \code{B} sub-samples}

\item{hc}{output of \code{\link{hclust}} function. If not provided, \code{\link{hclust}} is run with ward.D2 method}

\item{lambda}{lambda values for group lasso. If not provided, the function generates its own values of lambda}

\item{weightLevel}{a vector of size p for each level of the hierarchy. A zero indicates that the level will be ignored. If not provided, use 1/(height between 2 successive levels)}

\item{weightSizeGroup}{a vector}

\item{loss}{a character string specifying the loss function to use, valid options are: "ls" least squares loss (regression) and "logit" logistic loss (classification)}

\item{intercept}{should an intercept be included in the model ?}

\item{verbose}{print some informations}

\item{...}{Others parameters for \code{\link{gglasso}} function}
}
\value{
a stability.MLGL object containing :
\describe{
\item{lambda}{sequence of \code{lambda}.}
\item{B}{Number of bootstrap samples.}
\item{stability}{A matrix of size length(lambda)*number of groups containing the probability of selection of each group}
\item{var}{vector containing the index of covariates}
\item{group}{vector containing the index of associated groups of covariates}
\item{time}{computation time}
}
}
\description{
Stability selection for \code{\link{MLGL}}
}
\details{
Hierarhical clustering is performed with all the variables. Then, the partitions from the different
levels of the hierarchy are used in the differents run of MLGL for estimating the probability of selection of each group.
}
\examples{
\donttest{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- drop(X[,c(2,7,12)]\%*\%c(2,2,-2)+rnorm(50,0,0.5))
# Apply stability.MLGL method
res <- stability.MLGL(X,y)
}

}
\references{
Meinshausen and Buhlmann (2010). Stability selection. In : Journal of the Royal Statistical Society : Series B (Statistical Methodology) 72.4, p. 417-473.
}
\seealso{
\link{cv.MLGL}, \link{MLGL}
}
\author{
Quentin Grimonprez
}
