% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.fullProcess}
\alias{print.fullProcess}
\title{Print Values

Print a \code{\link{fullProcess}} object}
\usage{
\method{print}{fullProcess}(x, ...)
}
\arguments{
\item{x}{\code{\link{fullProcess}} object}

\item{...}{Not used.}
}
\description{
Print Values

Print a \code{\link{fullProcess}} object
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- drop(X[,c(2,7,12)]\%*\%c(2,2,-2)+rnorm(50,0,0.5))
# Apply MLGL method
res <- fullProcess(X, y)
print(res)

}
\seealso{
\link{fullProcess} \link{summary.fullProcess}
}
