% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_mhealth_csv}
\alias{import_mhealth_csv}
\title{Import raw multi-channel accelerometer data stored in mHealth Specification}
\usage{
import_mhealth_csv(filepath)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}
}
\value{
dataframe. The imported multi-channel accelerometer signal, with the
  first column being the timestamps in POSXlct format, and the rest columns
  being accelerometer values in \eqn{g} unit.
}
\description{
\code{import_mhealth_csv} imports the raw multi-channel accelerometer data
  stored in mHealth Specification. Note that this function will fail when
  loading data that have size too big to fit in the memory. For large data
  file, please use \code{\link{import_mhealth_csv_chunked}} to load.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to import data stored in mHealth Specification during
  algorithm validation.
}

\examples{
  default_ops = options()
  options(digits.secs=3)
  # Use the sample mhealth csv file provided by the package
  filepath = system.file('extdata', 'mhealth.csv', package='MIMSunit')
  filepath

  # Load the file
  df = import_mhealth_csv(filepath)

  # Check loaded file
  head(df)

  # Check more
  summary(df)

  # Restore default options
  options(default_ops)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv_chunked}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv_chunked}()}
}
\concept{File I/O functions}
