#' MHTdiscrete: A package for Multiple Hypotheses Testing for Discrete Data.
#'
#' The MHTdiscrete package provides two categories of important functions for discrete data mutliple hypothese testing:
#' @section FWER controlling procedures:
#'        Single-step: MBonf.p.adjust, Tarone.p.adjust.
#'
#'        Step-down: MHolm.p.adjust, TH.p.adjust.
#'
#'        Step-up: MHoch.p.adjust, Roth.p.adjust
#'        .
#' @section FDR controlling procedures:
#'
#'        Step-down: MBL.p.adjust.
#'
#'        Step-up: MBH.p.adjust, GTBH.p.adjust, MBY.p.adjust, GTBY.p.adjust.
#'
#' @author Yalin Zhu
#' @references
#' Tarone, R. E. (1990).
#' A modified Bonferroni method for discrete data.
#' \emph{Biometrics}, \strong{46}: 515-522.
#'
#' Hommel, G., & Krummenauer, F. (1998).
#' Improvements and modifications of Tarone's multiple test procedure for discrete data.
#' \emph{Biometrics}, \strong{54}: 673-681.
#'
#' Holm, S. (1979).
#' A simple sequentially rejective multiple test procedure.
#' \emph{Scandinavian Journal of Statistics}, \strong{6}: 65-70.
#'
#' Roth, A. J. (1999).
#' Multiple comparison procedures for discrete test statistics.
#' \emph{Journal of statistical planning and inference}, \strong{82}: 101-117.
#'
#' Gilbert, P. B. (2005).
#' A modified false discovery rate multiple-comparisons procedure for discrete data, applied to human immunodeficiency virus genetics.
#' \emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, \strong{54}: 143-158.
#'
#' Benjamini, Y., and Hochberg, Y. (1995).
#'  Controlling the false discovery rate: a practical and powerful approach to multiple testing.
#'  \emph{Journal of the Royal Statistical Society Series B}, \strong{57}: 289-300.
#'
#' Benjamini, Y., and Yekutieli, D. (2001).
#' The control of the false discovery rate in multiple testing under dependency.
#' \emph{Annals of Statistics}, \strong{29}: 1165-1188.
#'
#' Benjamini, Y., and Liu, W. (1999).
#' A step-down multiple hypotheses testing procedure that controls the false discovery rate under independence.
#'  \emph{Journal of Statistical Planning and Inference}, \strong{82}: 163-170.
#'
#' @docType package
#' @name MHTdiscrete
NULL
