% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcVinEll}
\alias{calcVinEll}
\title{Calculate Geodesic Distance - Vincenty Ellipsoid Method}
\usage{
calcVinEll(
  latLongs,
  a = 6378137,
  b = 6356752.3142,
  f = 1/298.257223563,
  eps = 1e-12,
  iter = 100
)
}
\arguments{
\item{latLongs}{Two column matrix of latitudes/longitudes}

\item{a}{Equatorial radius of the earth, default is WGS-84 radius}

\item{b}{Polar radius of the earth, default is WGS-84 radius}

\item{f}{Flattening or inverse eccentricity, default eccentricity is WGS-84}

\item{eps}{Convergence criteria}

\item{iter}{Maximum number of iterations to attempt convergence}
}
\description{
This function calculates geodesic distance using the original Vincenty Ellipsoid method.
}
\examples{
# two-column matrix with latitude/longitude, in degrees
latLong = cbind(runif(n = 5, min = 0, max = 90),
                runif(n = 5, min = 0, max = 180))

# Vincenty Ellipsoid  distance formula
distMat = calcVinEll(latLongs = latLong)

}
