% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Patch-Class.R
\docType{class}
\name{Patch}
\alias{Patch}
\title{Patch Class Definition}
\format{An \code{\link{R6Class}} generator object}
\description{
A Patch is a single well-mixed population that is the smallest unit of simulation for MGDrivE.
}
\section{\strong{Constructor}}{

\itemize{
\item patchID: integer ID of this patch
\item genotypesID: character vector of genotypes
\item timeAq: integer vector of length 3 specifying the length of each aquatic stage
\item numPatches: integer, total number of patches in this simulation
\item adultEQ: integer, total adult population in this patch for the duration of the simulation
\item larvalEQ: integer, total larval population in this patch for the duration of the simulation
\item muAq: double vector, length 3, daily death rate for each aquatic stage
\item alpha: double, density-dependent centering parameter, see \code{\link{parameterizeMGDrivE}}
\item adultRatioF: named double vector, distribution of adult female genotypes, see \code{\link{parameterizeMGDrivE}}
\item adultRatioM: named double vector, distribution of adult male genotypes, see \code{\link{parameterizeMGDrivE}}
\item larvalRatio: named double vector, distribution of all aquatic genotypes, see \code{\link{parameterizeMGDrivE}}
\item eggReleases: egg release schedule for this patch, see \code{\link{basicRepeatedReleases}}
\item maleReleases: male release schedule for this patch, see \code{\link{basicRepeatedReleases}}
\item femaleReleases: female release schedule for this patch, see \code{\link{basicRepeatedReleases}}
\item matedFemaleReleases: mated females release schedule for this patch, see \code{\link{basicRepeatedReleases}}
}
}

\section{\strong{Methods}}{

\itemize{
\item set_NetworkPointer: see \code{\link{set_NetworkPointer_Patch}}
\item get_maleMigration: see \code{\link{get_maleMigration_Patch}}
\item get_femaleMigration: see \code{\link{get_femaleMigration_Patch}}
\item initialPopulation: see \code{\link{set_initialPopulation_Patch}}
\item setPopulation: see \code{\link{set_population_deterministic_Patch}} or \code{\link{set_population_stochastic_Patch}}
\item reset: see \code{\link{reset_Patch}}
\item oneDay_initOutput: see \code{\link{oneDay_initOutput_Patch}}
\item oneDay_writeOutput: see \code{\link{oneDay_writeOutput_Patch}}
\item oneDay_migrationOut: see \code{\link{oneDay_migrationOut_deterministic_Patch}} or \code{\link{oneDay_migrationOut_stochastic_Patch}}
\item oneDay_migrationIn: see \code{\link{oneDay_migrationIn_Patch}}
\item oneDay_PopDynamics: see \code{\link{oneDay_PopDynamics_Patch}}
\item oneDay_adultD: see \code{\link{oneDay_adultDeath_deterministic_Patch}} or \code{\link{oneDay_adultDeath_stochastic_Patch}}
\item oneDay_pupaDM: see \code{\link{oneDay_pupaDM_deterministic_Patch}} or \code{\link{oneDay_pupaDM_stochastic_Patch}}
\item oneDay_larvaDM: see \code{\link{oneDay_larvaDM_deterministic_Patch}} or \code{\link{oneDay_larvaDM_stochastic_Patch}}
\item oneDay_eggDM: see \code{\link{oneDay_eggDM_deterministic_Patch}} or \code{\link{oneDay_eggDM_stochastic_Patch}}
\item oneDay_pupation: see \code{\link{oneDay_pupation_deterministic_Patch}} or \code{\link{oneDay_pupation_stochastic_Patch}}
\item oneDay_releases: see \code{\link{oneDay_releases_Patch}}
\item oneDay_releaseEggs: see \code{\link{oneDay_eggReleases_Patch}}
\item oneDay_mating: see \code{\link{oneDay_mating_deterministic_Patch}} or \code{\link{oneDay_mating_stochastic_Patch}}
\item oneDay_layEggs: see \code{\link{oneDay_oviposit_deterministic_Patch}} or \code{\link{oneDay_oviposit_stochastic_Patch}}
}
}

\section{\strong{Fields}}{

\itemize{
\item patchID: integer ID of this patch
\item popAquatic: matrix, nGenotype x sum(timeAquatic), holding all eggs, larva, and pupa
\item popMale: vector, nGenotype x 1, holds adult males
\item popFemale: matrix, nGenotype x nGenotype, holds mated adult females
\item popHolder: vector, nGenotype x 1, temporary population storage
\item popPupSex: vector, nGenotype x 1, used in stochastic pupation as another temporary population
\item popUnmated: vector, nGenotype x 1, holds unmated females
\item mMig: matrix, nGenotype x nPatches, holds outbound males for migration, see \code{\link{oneDay_migrationOut_deterministic_Patch}} or \code{\link{oneDay_migrationOut_stochastic_Patch}}
\item fMig: array, nGenotype x nGenotype x nPatches, holds outbound females for migration, see \code{\link{oneDay_migrationOut_deterministic_Patch}} or \code{\link{oneDay_migrationOut_stochastic_Patch}}
\item popAquatict0: matrix, nGenotype x sum(timeAquatic), holding all eggs, larva, and pupa for reset, see \code{\link{reset_Patch}}
\item popMalet0: vector, nGenotype x 1, holds adult males for reset see \code{\link{reset_Patch}}
\item popFemalet0: matrix, nGenotype x nGenotype, holds mated adult females for reset see \code{\link{reset_Patch}}
\item eggReleases: list of egg releases for this patch. See \code{\link{oneDay_eggReleases_Patch}}
\item maleReleases: list of adult male releases for this patch. See \code{\link{oneDay_releases_Patch}}
\item femaleReleases: list of adult female releases for this patch. See \code{\link{oneDay_releases_Patch}}
\item matedFemaleReleases: list of mated adult female releases for this patch. See \code{\link{oneDay_releases_Patch}}
\item NetworkPointer: a reference to enclosing \code{\link{Network}}
}
}

\keyword{R6}
\keyword{class}
