% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_glmnet.R
\name{MFKnockoffs.stat.glmnet_lambda_difference}
\alias{MFKnockoffs.stat.glmnet_lambda_difference}
\title{GLM statistics for MFKnockoffs}
\usage{
MFKnockoffs.stat.glmnet_lambda_difference(X, X_k, y, family = "gaussian", ...)
}
\arguments{
\item{X}{original design matrix (size n-by-p)}

\item{X_k}{knockoff matrix (size n-by-p)}

\item{y}{response vector (length n). Quantitative for family="gaussian", 
or family="poisson" (non-negative counts). For family="binomial" 
should be either a factor with two levels, or a two-column matrix of counts 
or proportions (the second column is treated as the target class; for a factor, 
the last level in alphabetical order is the target class). For family="multinomial", 
can be a nc>=2 level factor, or a matrix with nc columns of counts or proportions. 
For either "binomial" or "multinomial", if y is presented as a vector, it will 
be coerced into a factor. For family="cox", y should be a two-column matrix with 
columns named 'time' and 'status'. The latter is a binary variable, with '1' 
indicating death, and '0' indicating right censored. The function Surv() in 
package survival produces such a matrix. For family="mgaussian", y is a matrix 
of quantitative responses.}

\item{family}{Response type (see above)}

\item{...}{additional arguments specific to 'glmnet' (see Details)}
}
\value{
A vector of statistics \eqn{W} (length p)
}
\description{
Fit a generalized linear model via penalized maximum likelihood and
computes the difference statistic
  \deqn{W_j = Z_j - \tilde{Z}_j}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the maximum values of the 
regularization parameter \eqn{\lambda} at which the jth variable 
and its knockoff enter the model, respectively.
}
\details{
This function uses \code{glmnet} to compute the regularization path
on a fine grid of \eqn{\lambda}'s.

The \code{nlambda} parameter can be used to control the granularity of the 
grid of \eqn{\lambda}'s. The default value of \code{nlambda} is \code{100}.

If the family is 'binomial' and a lambda sequence is not provided by the user, 
this function generates it on a log-linear scale before calling 'glmnet'.

The default response family is 'gaussian', for a linear regression model.
Different response families (e.g. 'binomial') can be specified by passing an
optional parameter 'family'.

For a complete list of the available additional arguments, see \link[glmnet]{glmnet}.
}
\examples{
p=100; n=200; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)

knockoffs = function(X) MFKnockoffs.create.gaussian(X, mu, Sigma)
# Basic usage with default arguments
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, 
                           statistic=MFKnockoffs.stat.glmnet_lambda_difference)
print(result$selected)

# Advanced usage with custom arguments
foo = MFKnockoffs.stat.glmnet_lambda_difference
k_stat = function(X, X_k, y) foo(X, X_k, y, nlambda=200)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics for knockoffs: \code{\link{MFKnockoffs.stat.forward_selection}},
  \code{\link{MFKnockoffs.stat.glmnet_coef_difference}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference}},
  \code{\link{MFKnockoffs.stat.random_forest}},
  \code{\link{MFKnockoffs.stat.sqrt_lasso}},
  \code{\link{MFKnockoffs.stat.stability_selection}}
}
