% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_approximate_gaussian.R
\name{MFKnockoffs.create.approximate_gaussian}
\alias{MFKnockoffs.create.approximate_gaussian}
\title{Sample approximate second-order multivariate Gaussian knockoff variables}
\usage{
MFKnockoffs.create.approximate_gaussian(X, method = c("asdp", "equi", "sdp"),
  shrink = F)
}
\arguments{
\item{X}{normalized n-by-p realization of the design matrix}

\item{method}{either 'equi', 'sdp' or 'asdp' (default:'asdp')
This will be computed according to 'method', if not supplied}

\item{shrink}{whether to shrink the estimated covariance matrix (default: FALSE)}
}
\value{
n-by-p matrix of knockoff variables
}
\description{
Samples approximate second-order multivariate Gaussian knockoff variables
for the original variables.
}
\details{
If the argument \code{shrink} is set to TRUE, a James-Stein-type shrinkage estimator for
the covariance matrix is used instead of the traditional maximum-likelihood estimate. This option
requires the package \code{corpcor}. Type \code{?corpcor::cov.shrink} for more details.

Even if the argument \code{shrink} is set to FALSE, in the case that the estimated covariance 
matrix is not positive-definite, this function will apply some shrinkage.

To use SDP knockoffs, you must have a Python installation with 
CVXPY. For more information, see the vignette on SDP knockoffs:
\code{vignette('sdp', package='MFKnockoffs')}
}
\references{
Candes et al., Panning for Gold: Model-free Knockoffs for High-dimensional Controlled Variable Selection,
  arXiv:1610.02351 (2016).
  \href{https://statweb.stanford.edu/~candes/MF_Knockoffs/index.html}{https://statweb.stanford.edu/~candes/MF_Knockoffs/index.html}
}
\seealso{
Other methods for creating knockoffs: \code{\link{MFKnockoffs.create.fixed}},
  \code{\link{MFKnockoffs.create.gaussian}}
}
