\name{rainman}
\alias{rainman}
\docType{data}
\title{Perception of points in a swarm}
\description{
  Five raters were asked to guess the number of points in a swarm for 10
  different figures (which - unknown to the raters - were each repeated
  three times).
}
\usage{data(rainman)}
\format{
  A data frame with 30 observations on the following 6 variables.
  \describe{
    \item{\code{SAND}}{The true number of points in the swarm. Each
      picture is replicated thrice}
    \item{\code{ME}}{Ratings from judge 1}
    \item{\code{TM}}{Ratings from judge 2}
    \item{\code{AJ}}{Ratings from judge 3}
    \item{\code{BM}}{Ratings from judge 4}
    \item{\code{LO}}{Ratings from judge 5}
  }
}
\details{
The raters har approximately 10 seconds to judge each picture, and the
thought it was 30 different pictures. Before starting the experiment
they were shown 6 (unrelated) pictures and were told the number of
points in each of those pictures. The SAND column contains the picture
id and the true number of points in the swarm.
}
\source{
Collected by Claus Ekstrom. 
}
%\references{
%%  ~~ possibly secondary sources and usages ~~
%}
\examples{
data(rainman)
long <- data.frame(stack(rainman[,2:6]), figure=factor(rep(rainman$SAND,5)))
figind <- interaction(long$figure,long$ind)
# Use a linear random effect model from the 
# lme4 package if available
if(require(lme4)) {
  model <- lmer(values ~ (1|ind) + (1|figure) + (1|figind), data=long)
}

#
# Point swarms were generated by the following program
#

set.seed(2) # Original
npoints <- sample(4:30)*4
nplots <- 10
pdf(file="swarms.pdf", onefile=TRUE)

s1 <- sample(npoints[1:nplots])
print(s1)
for (i in 1:nplots) {    
  n <- s1[i]
  set.seed(n)
  x <- runif(n)
  y <- runif(n)    
  plot(x,y, xlim=c(-.15, 1.15), ylim=c(-.15, 1.15), pch=20, axes=FALSE,
       xlab="", ylab="")
}
s1 <- sample(npoints[1:nplots])
print(s1)
for (i in 1:nplots) {    
  n <- s1[i]
  set.seed(n)
  x <- runif(n)
  y <- runif(n)    
  plot(y,x, xlim=c(-.15, 1.15), ylim=c(-.15, 1.15), pch=20, axes=FALSE,
       xlab="", ylab="")
}
s1 <- sample(npoints[1:nplots])
print(s1)
for (i in 1:nplots) {    
  n <- s1[i]
  set.seed(n)
  x <- runif(n)
  y <- runif(n)    
  plot(-x,y, xlim=c(-1.15, .15), ylim=c(-.15, 1.15), pch=20, axes=FALSE,
       xlab="", ylab="")
}
dev.off()
}
\keyword{datasets}
