% Generated by roxygen2 (4.0.2): do not edit by hand
\name{LossVol}
\alias{LossVol}
\title{Loss Function for volatility forecasts}
\usage{
LossVol(realized, evaluated, which = "SE1")
}
\arguments{
\item{realized}{a vector with some realized volatility measure}

\item{evaluated}{a vector or a matrix of volatility forecasts}

\item{which}{The loss function to use. possible choices are: \code{'SE1','SE2','QLIKE','R2LOG','AE1','AE2'}, for further information
see Bernardi and Catania (2014) or Hansen and Lunde (2005).}
}
\value{
A matrix with the forecast losses
}
\description{
Calculate the losses associated with volatility (standard deviation) forecasts
}
\author{
Leopoldo Catania & Mauro Bernardi
}
\references{
Koenker, R., & Bassett, G. (1978). Regression quantiles. Econometrica, 46(1), 33-50.

Gonzalez-Rivera G, Lee TH, Mishra S (2004). Forecasting volatility: A reality check based on option pricing, utility function, value-at-risk, and predictive likelihood." International Journal of Forecasting, 20(4), 629-645. ISSN 0169-2070. \url{doi:http://dx.doi.org/10.1016/j.ijforecast.2003.10.003}. URL \url{http://www.sciencedirect.com/science/article/pii/S0169207003001420}.

Hansen PR, Lunde A (2005). A forecast comparison of volatility models: does anything beat a GARCH(1,1)?" Journal of Applied Econometrics, 20(7), 873-889. ISSN 1099-1255. \url{doi:10.1002/jae.800}. URL \url{http://dx.doi.org/10.1002/jae.800}.

Bernardi M. and Catania L. (2014) The Model Confidence Set package for R. URL \url{http://arxiv.org/abs/1410.8504}
}

