% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{osteopain_2wkabs}
\alias{osteopain_2wkabs}
\title{Studies of treatments for pain relief in patients with osteoarthritis}
\format{A data frame in long format (one row per arm and study), with 74 rows and 7 variables:
\itemize{
\item \code{studyID} Study identifiers
\item \code{agent} Character data indicating the agent to which participants were randomised
\item \code{dose} Numeric data indicating the standardised dose received
\item \code{class} Character data indicating the drug class to which the agent belongs to
\item \code{y} Numeric data indicating the mean pain score on the WOMAC scale in a study arm
\item \code{se} Numeric data indicating the standard error for the mean pain score on the WOMAC scale in a study arm
}}
\source{
Pfizer Ltd.
}
\usage{
osteopain_2wkabs
}
\description{
A dataset from a systematic review of interventions for pain relief in osteoarthritis, used previously
in \insertCite{pedder2019;textual}{MBNMAdose}. The outcome is continuous, and aggregate data responses correspond to
the mean WOMAC pain score at 2 weeks follow-up. The dataset includes 18 Randomised-Controlled Trials (RCTs),
comparing 8 different agents with placebo. In total there were 26 different treatments (combination of dose and
agent). The active treatments can also be grouped into 3 different classes, within which they have similar
mechanisms of action.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
