% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{forecast.marx}
\alias{forecast.marx}
\title{Forecasting function for the MARX model}
\usage{
forecast.marx(y, X, p_C, p_NC, X.for, h, M, N)
}
\arguments{
\item{y}{Data vector y.}

\item{X}{(optional) Matrix with data (column represent a series).}

\item{p_C}{Number of lags (causal order).}

\item{p_NC}{Number of leads (noncausal order).}

\item{X.for}{(optional) Matrix with forecasted values for X (column represents series).}

\item{h}{Forecast horizon h.}

\item{M}{(optional) Truncation value M for MA representation. Default value: 50.}

\item{N}{(optional) Number of simulations to forecast noncausal component. Default: 10,000.}
}
\value{
\item{y.for}{Vector containing forecasted values for y.}
}
\description{
This function allows you to forecast with the mixed causal-noncausal model with possibly exogenous regressors.
}
\examples{
## Forecasting MAR(0,1) model 4-periods ahead for lnbev (from dataset)
data <- MARX::dataset[,2]
y.for <- forecast.marx(y=data, p_C=0, p_NC=1, h=4, M=50, N=1000)
}
\author{
Sean Telg
}
\keyword{forecasting}
