% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_DROPLET_09_ADHOC_GENE_6_PlotSJPositions.R
\name{adhocGene.PlotSJPosition.10x}
\alias{adhocGene.PlotSJPosition.10x}
\title{Plots the locations of specified splice junction relative to isoforms}
\usage{
adhocGene.PlotSJPosition.10x(
  MarvelObject,
  coord.intron,
  coord.intron.ext = 50,
  rescale_introns = FALSE,
  show.protein.coding.only = TRUE,
  anno.label.size = 3,
  anno.colors = c("black", "gray", "red")
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{coord.intron}{Character string. Coordinates of splice junction whose splice junction will be plotted.}

\item{coord.intron.ext}{Numeric value. Number of bases to extend the splice junction start and end coordinates into the exons. Helpful to enhance splice junction locations on the plot. Default is \code{50}.}

\item{rescale_introns}{Logical value. If set to \code{TRUE}, the intron length will be shorten. Helpful when introns are very long and focus visualisation of exons and splice junctions. Default is \code{FALSE}.}

\item{show.protein.coding.only}{Logical value. If set to \code{TRUE} (default), only protein-coding isoforms will be displayed.}

\item{anno.label.size}{Numeric value. Font size of isoform ID labels. Default is \code{3}.}

\item{anno.colors}{Vector of character strings. Colors for non-coding UTRs, coding exons, and splice junctions, respectively. Default is \code{c("black", "gray", "red")}.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$adhocGene$SJPosition$Plot}, \code{MarvelObject$adhocGene$SJPosition$metadata}, \code{MarvelObject$adhocGene$SJPosition$exonfile}, and \code{MarvelObject$adhocGene$SJPosition$cdsfile}.
}
\description{
Plots the locations of specified splice junction relative to isoforms. List of isoforms are retrieved from GTF.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

marvel.demo.10x <- adhocGene.PlotSJPosition.10x(
                        MarvelObject=marvel.demo.10x,
                        coord.intron="chr1:100:1001",
                        rescale_introns=FALSE,
                        show.protein.coding.only=TRUE,
                        anno.label.size=1.5
                        )
}
