% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_02_PREPROCESS_3_ValidateSJ.R
\name{ValidateSJ.10x}
\alias{ValidateSJ.10x}
\title{Validate splice junctions}
\usage{
ValidateSJ.10x(MarvelObject, keep.novel.sj = FALSE)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{AnnotateSJ.10x} function.}

\item{keep.novel.sj}{Logical value. If set to \code{TRUE}, novel splice junctions will be retained for downstream analysis. Novel splice junctions are defined as splice junctions with one end reported in GTF while the other was not reported in GTF. Default value is \code{FALSE}.}
}
\value{
An object of class S3 containing the updated slots \code{MarvelObject$sj.metadata} and \code{MarvelObject$sj.count.matrix}.
}
\description{
Retains splice junctions whose start and end belong to the same gene.
}
\examples{

# Load un-processed MARVEL object
marvel.demo.10x.raw <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.raw.rds",
                               package="MARVEL")
                               )

# Annotate gene metadata
marvel.demo.10x <- AnnotateGenes.10x(MarvelObject=marvel.demo.10x.raw)

# Annotate junction metadata
marvel.demo.10x <- AnnotateSJ.10x(MarvelObject=marvel.demo.10x)

# Validate junctions
marvel.demo.10x <- ValidateSJ.10x(MarvelObject=marvel.demo.10x)
}
