% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_04_DE_3_VolcanoPlot_SJ.R
\name{PlotDEValues.SJ.10x}
\alias{PlotDEValues.SJ.10x}
\title{Plot differential splice junction analysis results}
\usage{
PlotDEValues.SJ.10x(
  MarvelObject,
  pval = 0.05,
  log2fc = NULL,
  delta = 5,
  min.gene.norm = 0,
  anno = FALSE,
  anno.coord.intron = NULL,
  label.size = 2
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues.Genes.10x} function.}

\item{pval}{Numeric value. p-value, below which, the splice junction is considered differentially spliced. To be used in conjunction with \code{log2fc}, \code{delta}, and \code{min.gene.norm}. Default is \code{0.05}.}

\item{log2fc}{Numeric value. Absolute log2 fold change, above which, the splice junction is considered differentially spliced. This option should be \code{NULL} if \code{delta} has been specified.}

\item{delta}{Numeric value. Absolute differences in average PSI values between the two cell groups, above which, the splice junction is considered differentially spliced. This option should be \code{NULL} if \code{log2fc} has been specified.}

\item{min.gene.norm}{Numeric value. The average normalised gene expression across the two cell groups above which the splice junction is considered differentially spliced. Default is \code{0}.}

\item{anno}{Logical value. If set to \code{TRUE}, user-specific spliced genes in \code{anno.coord.intron} will be annotated on the plot. Default is \code{FALSE}.}

\item{anno.coord.intron}{Vector of character strings. If \code{anno} set to \code{TRUE}, splice junction coordinates specified here will be annotated on the plot.}

\item{label.size}{Numeric value. If \code{anno} set to \code{TRUE}, the font size of the annotations on the plot will be adjusted to the size specified here. Default is \code{2}.}
}
\value{
An object of class S3 with a new slots \code{MarvelObject$DE$SJ$VolcanoPlot$SJ$Plot} and \code{MarvelObject$DE$SJ$VolcanoPlot$SJ$Data}.
}
\description{
Volcano plot of results from differential splice junction analysis. x-axis represents the average normalised gene expression across the two cell groups. y-axis represents the differences or log2 fold change between the two cell groups.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

marvel.demo.10x <- PlotDEValues.SJ.10x(
                        MarvelObject=marvel.demo.10x,
                        pval=0.05,
                        delta=5,
                        min.gene.norm=1.0,
                        anno=FALSE
                        )

# Check outputs
marvel.demo.10x$DE$SJ$VolcanoPlot$SJ$Plot
head(marvel.demo.10x$DE$SJ$VolcanoPlot$SJ$Data)
}
