% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_07_PREDICT_NMD_1_ParseGTF.R
\name{ParseGTF}
\alias{ParseGTF}
\title{Parse Gene Transfer File (GTF)}
\usage{
ParseGTF(MarvelObject, gtf)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues.PSI} function.}

\item{gtf}{Data frame. Nine-column data frame containing gene, transcript, and exon information. Please see https://www.gencodegenes.org/pages/data_format.html for formatting. This GTF file should be the same as the one used for detecting the initial alternative splicing events, e.g. rMATS etc.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$NMD$GTF}.
}
\description{
\code{ParseGTF} parses the gene transfer file (GTF) for downstream nonsense-mediated decay (NMD) prediction.
}
\details{
This function parses the GTF in order to generate new columns for gene IDs, transcript IDs, and transcript type. These information are extracted from the attribute (9th) column for a standard GTF. These information will be used for downstream NMD prediction.
}
\examples{
# Load input
path_to_file <- system.file("extdata/Data", "gencode.v31.annotation.gtf", package="MARVEL")
gtf <- read.table(path_to_file, sep="\t", header=FALSE, stringsAsFactors=FALSE,
             na.strings="NA")

marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- ParseGTF(MarvelObject=marvel, gtf=gtf)

# Check output
marvel$NMD$GTF[1:5, ]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
