% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_07_PREDICT_NMD_2_0_FindPTC.R
\name{FindPTC}
\alias{FindPTC}
\title{Find Premature Terminal Codon (PTC)}
\usage{
FindPTC(MarvelObject, psi.de.sig, psi.de.diff)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues.PSI} and \code{ParseGTF} functions.}

\item{psi.de.sig}{Numeric value. Adjusted p-value below which the splicing event will be analysed for PTCs.}

\item{psi.de.diff}{Numeric value. Positive delta percent spliced-in (PSI) value above which the splicing event will be analysed for PTCs. "Positive" because only an increased in PSI value leads to increased alternative exon inclusion in the transcript.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$NMD$Prediction}. Transcripts containing splicing events meeting the \code{psi.de.sig} and \code{psi.de.diff} criteria are categorised based on the presence or absence of PTCs.
}
\description{
\code{FindPTC} finds PTC(s) introduced by alternative exons into protein-coding transcripts.
}
\details{
This function finds PTC(s) introduced by alternative exons into protein-coding transcripts. It also records the distance between a PTCs and the final splice junction for a given protein-coding transcript. Non-protein-coding transcripts or transcripts in which splicing events are located outside of the transcripts' open-reading frame (ORF) are not analysed for PTCs but are noted.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- FindPTC(MarvelObject=marvel,
                  psi.de.sig=0.10,
                  psi.de.diff=0.05
                  )

# Check output
marvel$NMD$Prediction
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
