test_that("cross-sectional gaussian", {
  
  gdsfile  <- system.file("extdata", "geno.gds",  package = "MAGEE")
  bgenfile <- system.file("extdata", "geno.bgen", package = "MAGEE")
  samplefile <- system.file("extdata", "geno.sample", package = "MAGEE")
  group.file <- system.file("extdata", "SetID.withweights.txt", package = "MAGEE")
  data(example)
  set.seed(123)
  pheno <- rbind(example$pheno, example$pheno[1:100, ])
  pheno$id <- 1:500
  pheno$disease[sample(1:500,20)] <- NA
  pheno$age[sample(1:500,20)] <- NA
  pheno$sex[sample(1:500,20)] <- NA
  pheno <- pheno[sample(1:500,450), ]
  pheno <- pheno[pheno$id <= 400, ]
  kins <- example$GRM
  
  ### single thread with kins
  obj1 <- glmmkin(trait ~ age + sex, data = pheno, kins = kins, id = "id", family = gaussian(link = "identity"))
  out1 <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out1_bgen <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(signif(range(out1$MV.pval)), signif(c(0.1223048, 0.9724113)))
  expect_equal(signif(range(out1$MF.pval)), signif(c(0.1898314, 0.9978167)))
  expect_equal(signif(range(out1$IV.pval)), signif(c(0.06457353, 0.97197688)))
  expect_equal(signif(range(out1$IF.pval)), signif(c(0.07154824, 0.98409911)))
  expect_equal(signif(range(out1$JV.pval)), signif(c(0.0461317, 0.9581358)))
  expect_equal(signif(range(out1$JF.pval)), signif(c(0.09825523, 0.99174298)))
  expect_equal(signif(range(out1$JD.pval)), signif(c(0.1060679, 0.9862423)))
  expect_equal(out1, out1_bgen)

  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)

  tmpout <- SMMAT(null.obj=obj1, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1$MV.pval, tmpout$S.pval)
  expect_equal(out1$MF.pval, tmpout$E.pval)

  ### single thread without kins
  obj2 <- glmmkin(trait ~ age + sex, data = pheno, kins = NULL, id = "id", family = gaussian(link = "identity"))
  out2 <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out2_bgen <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(signif(range(out2$MV.pval)), signif(c(0.1137967, 0.7420214)))
  expect_equal(signif(range(out2$MF.pval)), signif(c(0.1332550, 0.8844902)))
  expect_equal(signif(range(out2$IV.pval)), signif(c(0.07857723, 0.98642152)))
  expect_equal(signif(range(out2$IF.pval)), signif(c(0.1068216, 0.9959352)))
  expect_equal(signif(range(out2$JV.pval)), signif(c(0.08249361, 0.89005467)))
  expect_equal(signif(range(out2$JF.pval)), signif(c(0.1584977, 0.9820383)))
  expect_equal(signif(range(out2$JD.pval)), signif(c(0.1740379, 0.9845512)))
  expect_equal(out2, out2_bgen)
  
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)

  tmpout <- SMMAT(null.obj=obj2, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2$MV.pval, tmpout$S.pval)
  expect_equal(out2$MF.pval, tmpout$E.pval)
  
  ### multi-thread
  skip_on_cran()
  out1.tmp <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1.tmp)
  out1.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out1, out1.lowmem.tmp)
  out1_bgen.tmp <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1_bgen.tmp)
  out2.tmp <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2.tmp)
  out2.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out2, out2.lowmem.tmp)
  out2_bgen.tmp <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2_bgen.tmp)
  
  ### re-order id
  idx <- sample(nrow(pheno))
  pheno <- pheno[idx, ]
  obj1 <- glmmkin(trait ~ age + sex, data = pheno, kins = kins, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile,  group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  obj2 <- glmmkin(trait ~ age + sex, data = pheno, kins = NULL, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
  
  ### re-order id
  idx <- sample(nrow(kins))
  kins <- kins[idx, idx]
  obj1 <- glmmkin(trait ~ age + sex, data = pheno, kins = kins, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  obj2 <- glmmkin(trait ~ age + sex, data = pheno, kins = NULL, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
})

test_that("cross-sectional binomial", {
  skip_on_cran()
  
  gdsfile <- system.file("extdata", "geno.gds", package = "MAGEE")
  bgenfile <- system.file("extdata", "geno.bgen", package = "MAGEE")
  samplefile <- system.file("extdata", "geno.sample", package = "MAGEE")
  group.file <- system.file("extdata", "SetID.withweights.txt", package = "MAGEE")
  data(example)
  set.seed(123)
  pheno <- rbind(example$pheno, example$pheno[1:100, ])
  pheno$id <- 1:500
  pheno$disease[sample(1:500,20)] <- NA
  pheno$age[sample(1:500,20)] <- NA
  pheno$sex[sample(1:500,20)] <- NA
  pheno <- pheno[sample(1:500,450), ]
  pheno <- pheno[pheno$id <= 400, ]
  kins <- example$GRM
  
  ### single thread with kins
  obj1 <- glmmkin(disease ~ age + sex, data = pheno, kins = kins, id = "id", family = binomial(link = "logit"))
  out1 <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out1_bgen <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(signif(range(out1$MV.pval)), signif(c(0.04569696, 0.66545029)))
  expect_equal(signif(range(out1$MF.pval)), signif(c(0.0717664, 0.8372688)))
  expect_equal(signif(range(out1$IV.pval)), signif(c(0.2310993, 0.9260350)))
  expect_equal(signif(range(out1$IF.pval)), signif(c(0.1028281, 0.9835639)))
  expect_equal(signif(range(out1$JV.pval)), signif(c(0.1126746, 0.8547623)))
  expect_equal(signif(range(out1$JF.pval),5), signif(c(0.1228627, 0.9610125),5))
  expect_equal(signif(range(out1$JD.pval)), signif(c(0.1362456, 0.9498088)))
  expect_equal(out1, out1_bgen)
  
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)

  tmpout <- SMMAT(null.obj=obj1, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1$MV.pval, tmpout$S.pval)
  expect_equal(out1$MF.pval, tmpout$E.pval)

  ### single thread without kins
  obj2 <- glmmkin(disease ~ age + sex, data = pheno, kins = NULL, id = "id", family = binomial(link = "logit"))
  out2 <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out2_bgen <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(signif(range(out2$MV.pval)), signif(c(0.01958317, 0.83039453)))
  expect_equal(signif(range(out2$MF.pval)), signif(c(0.03165378, 0.89714953)))
  expect_equal(signif(range(out2$IV.pval)), signif(c(0.1862096, 0.9224659)))
  expect_equal(signif(range(out2$IF.pval)), signif(c(0.07000326, 0.98470603)))
  expect_equal(signif(range(out2$JV.pval),5), signif(c(0.05232525, 0.91036406),5))
  expect_equal(signif(range(out2$JF.pval)), signif(c(0.06796507, 0.98442573)))
  expect_equal(signif(range(out2$JD.pval)), signif(c(0.06984052, 0.98116516)))
  expect_equal(out2, out2_bgen)
  
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  
  tmpout <- SMMAT(null.obj=obj2, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2$MV.pval, tmpout$S.pval)
  expect_equal(out2$MF.pval, tmpout$E.pval)
  
  ### multi-thread
  out1.tmp <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1.tmp)
  out1.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out1, out1.lowmem.tmp)
  out1_bgen.tmp <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1_bgen.tmp)
  out2.tmp <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2.tmp)
  out2.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out2, out2.lowmem.tmp)
  out2_bgen.tmp <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2_bgen.tmp)
  
  ### re-order id
  idx <- sample(nrow(pheno))
  pheno <- pheno[idx, ]
  obj1 <- glmmkin(disease ~ age + sex, data = pheno, kins = kins, id = "id", family = binomial(link = "logit"))
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  obj2 <- glmmkin(disease ~ age + sex, data = pheno, kins = NULL, id = "id", family = binomial(link = "logit"))
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
  
  ### re-order id
  idx <- sample(nrow(kins))
  kins <- kins[idx, idx]
  obj1 <- glmmkin(disease ~ age + sex, data = pheno, kins = kins, id = "id", family = binomial(link = "logit"))
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  obj2 <- glmmkin(disease ~ age + sex, data = pheno, kins = NULL, id = "id", family = binomial(link = "logit"))
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
})

### multi-phenotype MAGEE
test_that("multiple phenotypes gaussian", {
  skip_on_cran()
  
  gdsfile <- system.file("extdata", "geno.gds", package = "MAGEE")
  bgenfile <- system.file("extdata", "geno.bgen", package = "MAGEE")
  samplefile <- system.file("extdata", "geno.sample", package = "MAGEE")
  group.file <- system.file("extdata", "SetID.withweights.txt", package = "MAGEE")
  data(example)
  set.seed(103)
  kins <- example$GRM
  tau1 <- matrix(c(3,0.5,0,0.5,2.5,-0.1,0,-0.1,3),3,3)
  tau2 <- matrix(c(2.5,0.8,0.2,0.8,4.8,-0.1,0.2,-0.1,2.8),3,3)
  kins.chol <- chol(tau1 %x% kins + tau2 %x% diag(400))
  tmp <- as.vector(crossprod(kins.chol, rnorm(1200)))
  x1 <- rnorm(400)
  x2 <- rbinom(400,1,0.5)
  pheno <- data.frame(id = 1:400, x1 = x1, x2 = x2, y1 = 0.5*x1+0.8*x2+tmp[1:400], y2 = x1-0.3*x2+tmp[401:800], y3 = x2+tmp[801:1200])
  ### single thread with kins
  obj1 <- glmmkin(cbind(y1,y2,y3)~x1+x2, data = pheno, kins = kins, id = "id", family = gaussian(link = "identity"))
  out1 <- MAGEE(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out1_bgen <- MAGEE(null.obj=obj1, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  
  expect_equal(signif(range(out1$MV.pval)), signif(c(0.1689182, 0.9277765)))
  expect_equal(signif(range(out1$MF.pval)), signif(c(0.1290289, 0.8907589)))
  expect_equal(signif(range(out1$IV.pval)), signif(c(0.1060731, 0.9129642)))
  expect_equal(signif(range(out1$IF.pval)), signif(c(0.1785101, 0.9041499)))
  expect_equal(signif(range(out1$JV.pval)), signif(c(0.261298, 0.940976)))
  expect_equal(signif(range(out1$JF.pval),5), signif(c(0.2591923, 0.9611525),5))
  expect_equal(signif(range(out1$JD.pval),5), signif(c(0.2641673, 0.9661435),5))
  expect_equal(out1, out1_bgen)
  
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  
  tmpout <- SMMAT(null.obj=obj1, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1$MV.pval, tmpout$S.pval)
  expect_equal(out1$MF.pval, tmpout$E.pval)

  ### single thread without kins
  obj2 <- glmmkin(cbind(y1,y2,y3)~x1+x2, data = pheno, kins = NULL, id = "id", family = gaussian(link = "identity"))
  out2 <- MAGEE(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out2_bgen <- MAGEE(null.obj=obj2, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  
  expect_equal(signif(range(out2$MV.pval)), signif(c(0.0005204763, 0.7454647180)))
  expect_equal(signif(range(out2$MF.pval)), signif(c(0.0004170892, 0.6362776242)))
  expect_equal(signif(range(out2$IV.pval)), signif(c(0.1830878, 0.9157741)))
  expect_equal(signif(range(out2$IF.pval)), signif(c(0.2745413, 0.8634707)))
  expect_equal(signif(range(out2$JV.pval)), signif(c(0.003123721, 0.803773857)))
  expect_equal(signif(range(out2$JF.pval)), signif(c(0.004704365, 0.737300921)))
  expect_equal(signif(range(out2$JD.pval)), signif(c(0.002961206, 0.761153895)))
  expect_equal(out2, out2_bgen)
  
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  
  tmpout <- SMMAT(null.obj=obj2, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2$MV.pval, tmpout$S.pval)
  expect_equal(out2$MF.pval, tmpout$E.pval)
  
  ### multi-thread
  out1.tmp <- MAGEE(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1.tmp)
  out1.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out1, out1.lowmem.tmp)
  out1_bgen.tmp <- MAGEE(null.obj=obj1, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1_bgen.tmp)
  out2.tmp <- MAGEE(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2.tmp)
  out2.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out2, out2.lowmem.tmp)
  out2_bgen.tmp <- MAGEE(null.obj=obj2, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2_bgen.tmp)
  
  ### re-order id
  idx <- sample(nrow(pheno))
  pheno <- pheno[idx, ]
  obj1 <- glmmkin(cbind(y1,y2,y3)~x1+x2, data = pheno, kins = kins, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  obj2 <- glmmkin(cbind(y1,y2,y3)~x1+x2, data = pheno, kins = NULL, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
  
  ### re-order id
  idx <- sample(nrow(kins))
  kins <- kins[idx, idx]
  obj1 <- glmmkin(cbind(y1,y2,y3)~x1+x2, data = pheno, kins = kins, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="x1", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  obj2 <- glmmkin(cbind(y1,y2,y3)~x1+x2, data = pheno, kins = NULL, id = "id", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="x1", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="x1", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
})

### longitudinal MAGEE
test_that("longitudinal random time trend gaussian", {
  skip_on_cran()
  
  gdsfile  <- system.file("extdata", "geno.gds",  package = "MAGEE")
  bgenfile <- system.file("extdata", "geno.bgen", package = "MAGEE")
  samplefile <- system.file("extdata", "geno.sample", package = "MAGEE")
  group.file <- system.file("extdata", "SetID.withweights.txt", package = "MAGEE")
  data(example)
  set.seed(123)
  pheno <- example$pheno2
  pheno$y.trend[sample(1:2000,20)] <- NA
  pheno$sex[sample(1:2000,20)] <- NA
  pheno$time[sample(1:2000,20)] <- NA
  pheno <- pheno[sample(1:2000,1950), ]
  kins <- example$GRM
  ### single thread with kins
  obj1 <- glmmkin(y.trend ~ sex + time, data = pheno, kins = kins, id = "id",random.slope = "time", family = gaussian(link = "identity"))
  out1 <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out1_bgen <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(signif(range(out1$MV.pval)), signif(c(0.1323623, 0.9703559)))
  expect_equal(signif(range(out1$MF.pval)), signif(c(0.1329606, 0.9956268)))
  expect_equal(signif(range(out1$IV.pval)), signif(c(0.01062191, 0.97955979)))
  expect_equal(signif(range(out1$IF.pval)), signif(c(0.02570341, 0.98928108)))
  expect_equal(signif(range(out1$JV.pval)), signif(c(0.02309769, 0.98493272)))
  expect_equal(signif(range(out1$JF.pval)), signif(c(0.08378947, 0.98091932)))
  expect_equal(signif(range(out1$JD.pval)), signif(c(0.07804338, 0.97458040)))
  expect_equal(out1, out1_bgen)

  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)

  tmpout <- SMMAT(null.obj=obj1, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1$MV.pval, tmpout$S.pval)
  expect_equal(out1$MF.pval, tmpout$E.pval)

  out1.time <- MAGEE(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out1_bgen.time <- MAGEE(null.obj=obj1, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1$MV.pval, out1.time$MV.pval)
  expect_equal(out1$MF.pval, out1.time$MF.pval)
  expect_equal(signif(range(out1.time$IV.pval)), signif(c(0.05622821, 0.94626695)))
  expect_equal(signif(range(out1.time$IF.pval)), signif(c(0.1249703, 0.9084682)))
  expect_equal(signif(range(out1.time$JV.pval)), signif(c(0.06361535, 0.95186442)))
  expect_equal(signif(range(out1.time$JF.pval)), signif(c(0.1537416, 0.9730217)))
  expect_equal(signif(range(out1.time$JD.pval)), signif(c(0.1703858, 0.9771715)))
  expect_equal(out1.time, out1_bgen.time)

  obj1.time.tmp <- MAGEE.prep(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.time.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1.time, out1.time.lowmem)
  
  ### single thread without kins
  obj2 <- glmmkin(y.trend ~ sex + time, data = pheno, kins = NULL, id = "id",random.slope = "time", family = gaussian(link = "identity"))
  out2 <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out2_bgen <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(signif(range(out2$MV.pval),5), signif(c(0.1566921, 0.9585805),5))
  expect_equal(signif(range(out2$MF.pval),5), signif(c(0.08264715, 0.98670558),5))
  expect_equal(signif(range(out2$IV.pval)), signif(c(0.01311423, 0.98538422)))
  expect_equal(signif(range(out2$IF.pval)), signif(c(0.03240826, 0.99806234)))
  expect_equal(signif(range(out2$JV.pval)), signif(c(0.01476963, 0.98448481)))
  expect_equal(signif(range(out2$JF.pval)), signif(c(0.06253546, 0.95890641)))
  expect_equal(signif(range(out2$JD.pval)), signif(c(0.06456337, 0.94498937)))
  expect_equal(out2, out2_bgen)

  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)

  tmpout <- SMMAT(null.obj=obj2, geno.file=gdsfile, group.file=group.file, tests = c("S", "E"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2$MV.pval, tmpout$S.pval)
  expect_equal(out2$MF.pval, tmpout$E.pval)
  
  out2.time <- MAGEE(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  out2_bgen.time <- MAGEE(null.obj=obj2, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2$MV.pval, out2.time$MV.pval)
  expect_equal(out2$MF.pval, out2.time$MF.pval)
  expect_equal(signif(range(out2.time$IV.pval)), signif(c(0.05766038, 0.98830210)))
  expect_equal(signif(range(out2.time$IF.pval)), signif(c(0.1213767, 0.9923014)))
  expect_equal(signif(range(out2.time$JV.pval)), signif(c(0.1108438, 0.9985899)))
  expect_equal(signif(range(out2.time$JF.pval)), signif(c(0.1110868, 0.9997269)))
  expect_equal(signif(range(out2.time$JD.pval)), signif(c(0.1201406, 0.9997803)))
  expect_equal(out2.time, out2_bgen.time)
  
  obj2.time.tmp <- MAGEE.prep(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.time.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2.time, out2.time.lowmem)
  
  ### multi-thread
  out1.tmp <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1.tmp)
  out1.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out1, out1.lowmem.tmp)
  out1_bgen.tmp <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1, out1_bgen.tmp)

  out1.time.tmp <- MAGEE(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1.time, out1.time.tmp)
  out1.time.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj1.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out1.time, out1.time.lowmem.tmp)
  out1_bgen.time.tmp <- MAGEE(null.obj=obj1, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out1.time, out1_bgen.time.tmp)
  
  out2.tmp <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2.tmp)
  out2.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out2, out2.lowmem.tmp)
  out2_bgen.tmp <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2, out2_bgen.tmp)
  
  out2.time.tmp <- MAGEE(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2.time, out2.time.tmp)
  out2.time.lowmem.tmp <- MAGEE.lowmem(MAGEE.prep.obj=obj2.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T, ncores = 2)
  expect_equal(out2.time, out2.time.lowmem.tmp)
  out2_bgen.time.tmp <- MAGEE(null.obj=obj2, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T, ncores = 2)
  expect_equal(out2.time, out2_bgen.time.tmp)
  
  ### re-order id
  idx <- sample(nrow(pheno))
  pheno <- pheno[idx, ]
  obj1 <- glmmkin(y.trend ~ sex + time, data = pheno, kins = kins, id = "id",random.slope = "time", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  tmpout <- MAGEE(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1.time, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  obj1.time.tmp <- MAGEE.prep(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.time.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1.time, out1.time.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  tmpout <- MAGEE(null.obj=obj1, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen.time, tmpout)
  obj2 <- glmmkin(y.trend ~ sex + time, data = pheno, kins = NULL, id = "id",random.slope = "time", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  tmpout <- MAGEE(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2.time, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  obj2.time.tmp <- MAGEE.prep(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.time.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2.time, out2.time.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
  tmpout <- MAGEE(null.obj=obj2, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen.time, tmpout)
  
  ### re-order id
  idx <- sample(nrow(kins))
  kins <- kins[idx, idx]
  obj1 <- glmmkin(y.trend ~ sex + time, data = pheno, kins = kins, id = "id",random.slope = "time", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1, tmpout)
  tmpout <- MAGEE(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1.time, tmpout)
  obj1.tmp <- MAGEE.prep(null.obj=obj1, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1, out1.lowmem)
  obj1.time.tmp <- MAGEE.prep(null.obj=obj1, interaction="time", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out1.time.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj1.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out1.time, out1.time.lowmem)
  tmpout <- MAGEE(null.obj=obj1, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen, tmpout)
  tmpout <- MAGEE(null.obj=obj1, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out1_bgen.time, tmpout)
  obj2 <- glmmkin(y.trend ~ sex + time, data = pheno, kins = NULL, id = "id",random.slope = "time", family = gaussian(link = "identity"))
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2, tmpout)
  tmpout <- MAGEE(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2.time, tmpout)
  obj2.tmp <- MAGEE.prep(null.obj=obj2, interaction="sex", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2, out2.lowmem)
  obj2.time.tmp <- MAGEE.prep(null.obj=obj2, interaction="time", geno.file=gdsfile, group.file=group.file, auto.flip = T)
  out2.time.lowmem <- MAGEE.lowmem(MAGEE.prep.obj=obj2.time.tmp, tests = c("JV", "JF", "JD"), use.minor.allele = T)
  expect_equal(out2.time, out2.time.lowmem)
  tmpout <- MAGEE(null.obj=obj2, interaction="sex", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen, tmpout)
  tmpout <- MAGEE(null.obj=obj2, interaction="time", geno.file=bgenfile, bgen.samplefile = samplefile, group.file=group.file, tests = c("JV", "JF", "JD"), use.minor.allele = T, auto.flip = T)
  expect_equal(out2_bgen.time, tmpout)
})
