% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predPPI_MACP.R
\name{predPPI_MACP}
\alias{predPPI_MACP}
\title{Predict Protein-Protein Interactions and Putative Complexes}
\usage{
predPPI_MACP(
  data,
  refcpx,
  tpath = tempdir(),
  data_processing = TRUE,
  data_imputing = TRUE,
  scaling = TRUE,
  keepMT = FALSE,
  pcc = TRUE,
  PCCN = TRUE,
  pcc_p = TRUE,
  spearman = TRUE,
  kendall = TRUE,
  bicor = TRUE,
  weighted_rank = TRUE,
  cosine = TRUE,
  jaccard = TRUE,
  dice = TRUE,
  apex = TRUE,
  minfo = TRUE,
  bayesian = TRUE,
  wcc = TRUE,
  euclidean = TRUE,
  manhattan = TRUE,
  canberra = TRUE,
  avg.distance = TRUE,
  rept = 10,
  corr_removal = FALSE,
  corr_cutoff = 0.5,
  classifier = c("glm", "svmRadial", "ranger"),
  verboseIter = TRUE,
  cv_fold = 5,
  plots = FALSE,
  subcellular_mtPPI = FALSE,
  organism = "mouse",
  csize = 3,
  d = 0.3,
  p = 2,
  max_overlap = 0.8,
  inflation = 9
)
}
\arguments{
\item{data}{A data matrix with rows including proteins and fractions
along the columns. see \code{\link{exampleData}}.}

\item{refcpx}{A list of known reference complexes.
see \code{\link{getCPX}}.}

\item{tpath}{A character string indicating the path to the project
directory. If the directory is
missing, it will be stored in the Temp directory.}

\item{data_processing}{If TRUE, removes proteins for which peptide only
detected in one fraction (i.e., "one-hit-wonders") across the
co-elution table, common contaminants (e.g., keratins) only for mouse
and human organisms and frequent flyers. Defaults to TRUE.
See \code{\link{data_filtering}}.}

\item{data_imputing}{if TRUE, imputes missing values in protein elution
profile matrix via average of adjacent rows. This function is
not applicable for missing values present in the first or last column.
Defaults to TRUE. See \code{\link{impute_MissingData}}.}

\item{scaling}{If TRUE, performs column and row-wise normalization.
Defaults to TRUE. See \code{\link{scaling}}.}

\item{keepMT}{if TRUE, removes all the non-mitochondrial proteins by
mapping the co-eluted proteins from chromatography fractions to MitoCarta
database. Note that this function is only applicable to
mouse or human organisms.Defaults to FALSE. See \code{\link{keepMT}}.}

\item{pcc}{If TRUE, computes pairwise protein profile similarity
using Pearson correlation metric. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{PCCN}{If TRUE, computes pairwise protein profile similarity using
Pearson correlation plus noise. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{pcc_p}{If TRUE, computes P-value of the Pearson correlation.
Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{spearman}{if TRUE, computes pairwise protein profile similarity using
spearman correlation. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{kendall}{if TRUE, computes pairwise protein profile similarity using
kendall correlation. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{bicor}{if TRUE, computes pairwise protein profile similarity using
biweight midcorrealtion (bicor) correlation. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{weighted_rank}{if TRUE, computes pairwise protein profile similarity
using weighted rank measure. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{cosine}{If TRUE, computes pairwise protein profile similarity
using cosine metric. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{jaccard}{If TRUE, computes pairwise protein profile similarity
using jaccard metric. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{dice}{if TRUE, computes pairwise protein profile similarity
using dice measure. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{apex}{If TRUE, computes pairwise protein profile similarity
using apex. Defaults to TRUE. See \code{\link{calculate_PPIscore}}.}

\item{minfo}{If TRUE, computes pairwise protein profile similarity
using mutual information. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{bayesian}{If TRUE, computes pairwise protein profile similarity using
Bayes correlation based on zero-count distribution. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{wcc}{If TRUE, computes pairwise protein profile similarity
using weighted cross correlation. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{euclidean}{if TRUE, computes pairwise protein profile similarity
using euclidean measure. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{manhattan}{if TRUE, computes pairwise protein profile similarity
using manhattan measure. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{canberra}{if TRUE, computes pairwise protein profile similarity
using canberra measure. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{avg.distance}{if TRUE, computes pairwise protein profile similarity
using avg.distance measure. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{rept}{Poisson iterations, defaults to 10. Defaults to TRUE.
See \code{\link{calculate_PPIscore}}.}

\item{corr_removal}{If TRUE, removes protein pairs with
correlation scores < the user defined threshold; defaults to FALSE.
See \code{\link{calculate_PPIscore}}.}

\item{corr_cutoff}{user defined threshold for correlation similarity
scores. Defaults to 0.5.See \code{\link{calculate_PPIscore}}.}

\item{classifier}{The type of classifier to use for ensemble or
individual model. See \code{caret} for the available classifiers.
Defaults to c("glm", "svmRadial", "ranger").
See \code{\link{ensemble_model}}.}

\item{verboseIter}{Logical value, indicating whether to check the status
of training process;defaults to FALSE. See \code{\link{ensemble_model}}.}

\item{cv_fold}{Number of partitions for cross-validation; defaults to 5.
See \code{\link{ensemble_model}}.}

\item{plots}{Logical value, indicating whether to plot the performance
of the learning algorithm using k-fold cross-validation;
defaults to FALSE. These plots are :
\itemize{ \item{pr_plot} - Precision-recall PLOT
  \item{roc_plot} - ROC plot
  \item{point_plot} - Point plot showing accuracy,
  F1-score , positive predictive value (PPV), sensitivity (SE) and MCC.}
  See \code{\link{ensemble_model}}.}

\item{subcellular_mtPPI}{if TRUE, removes PPIs occurring between outer mt
membrane (OMM) and matrix, between intermembrane space (IMS) and matrix,
as well as between any subcellular mt compartment (except OMM) and
cytosolic proteins as they deemed to be erroneous. Defaults to FALSE.
See \code{\link{subcellular.mtPPI}}.}

\item{organism}{Organism under study (i.e., mouse or human).
Defaults to mouse. See \code{\link{subcellular.mtPPI}}.}

\item{csize}{An integer, the minimum size of the predicted complexes.
Defaults to 2. See \code{\link{get_clusters}}.}

\item{d}{A number, density of predicted complexes. Defaults to 0.3.
See \code{\link{get_clusters}}.}

\item{p}{An integer, penalty value for the inclusion of each node.
Defaults to 2.
See \code{\link{get_clusters}}.}

\item{max_overlap}{A number, specifies the maximum allowed
overlap between two clusters. Defaults to 0.8.
See \code{\link{get_clusters}}.}

\item{inflation}{MCL inflation parameter. Defaults to 9.}
}
\value{
Return following data sets in the current directory including:
 \itemize{
 \item{unfilteredPPIs} - Unfiltered interactions
 \item{filteredPPI} - High-confidence interactions
 defined by ROC threshold.
 \item{High_confidence interactions_with_mt_sublocalization} - if
 subcellular.mtPPI is TRUE, it return high-confidene PPIs with mt
 sublocalization status.
 \item{predicted_cpx_clusterONE} - Putative complexes generated
 by clusterONE.
 \item{predicted_cpx_clusterONE_MCL} - Putative complexes generated
 by clusterONE and MCL.
 \item{Best_roc_curve_cutoff} - Best cutoff generated from ROC curve.}
}
\description{
This function first begins by executing several
pre-processing steps to improve the quality of the raw data, followed
by computing similarity between protein pairs using their co-elution
profiles. Computed features and and class labels generated
from reference complexes are then fed into an individual or
ensemble of ML classifiers.These models then generate a weighted protein
interaction network in which edge weights between protein nodes represent
the ML model's probability estimate for interaction.
High-confidence PPIs resulted from ROC-curve cutoff analysis is then
denoised and finally are partitioned via two-stage clustering,
first by ClusterONE,then by MCL clustering.
}
\details{
predPPI_MACP
}
