/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import uk.ac.rhul.cs.graph.Graph;

public class Layout {
    public double[] coordinates = null;

    public Layout(Graph graph) {
        this(graph.getNodeCount());
    }

    public Layout(int numberOfNodes) {
        this.coordinates = new double[2 * numberOfNodes];
        Arrays.fill(this.coordinates, 0.0);
    }

    public void fitToRectangle(Rectangle2D rectangle) {
        Rectangle2D currentBoundingRectangle = this.getBoundingRectangle();
        double sx = rectangle.getWidth() / currentBoundingRectangle.getWidth();
        double sy = rectangle.getHeight() / currentBoundingRectangle.getHeight();
        AffineTransform trans = AffineTransform.getTranslateInstance(-currentBoundingRectangle.getMinX() * sx, -currentBoundingRectangle.getMinY() * sy);
        trans.scale(sx, sy);
        trans.translate(rectangle.getMinX() / sx, rectangle.getMinY() / sy);
        trans.transform(this.coordinates, 0, this.coordinates, 0, this.coordinates.length / 2);
    }

    public Rectangle2D getBoundingRectangle() {
        if (this.coordinates.length == 0) {
            return null;
        }
        double minX = this.coordinates[0];
        double minY = this.coordinates[1];
        double maxX = this.coordinates[0];
        double maxY = this.coordinates[1];
        int n = this.coordinates.length;
        for (int i = 2; i < n; i += 2) {
            double x = this.coordinates[i];
            double y = this.coordinates[i + 1];
            if (minX > x) {
                minX = x;
            }
            if (minY > y) {
                minY = y;
            }
            if (maxX < x) {
                maxX = x;
            }
            if (!(maxY < y)) continue;
            maxY = y;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public void setCoordinates(int i, double x, double y) {
        this.coordinates[i * 2] = x;
        this.coordinates[i * 2 + 1] = y;
    }

    public int size() {
        return this.coordinates.length / 2;
    }

    public Point2D getCoordinates(int i) {
        return new Point2D.Double(this.coordinates[i * 2], this.coordinates[i * 2 + 1]);
    }
}

