/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapeResultViewerPanel;

public class ExtractClusterAction
extends AbstractAction {
    protected CytoscapeResultViewerPanel resultViewer;

    public ExtractClusterAction(CytoscapeResultViewerPanel panel) {
        super("Extract selected cluster(s)");
        this.resultViewer = panel;
        this.putValue("MnemonicKey", 69);
    }

    public void actionPerformed(ActionEvent event) {
        List<Node> selectedNodes = this.resultViewer.getSelectedCytoscapeNodeSet();
        CyNetwork network = this.resultViewer.getNetwork();
        if (network == null) {
            JOptionPane.showMessageDialog(this.resultViewer, "Cannot create network representation for the cluster:\nThe parent network has already been destroyed.", "Cannot create network", 0);
            return;
        }
        int[] indices = new int[selectedNodes.size()];
        int i = 0;
        for (Node node : selectedNodes) {
            indices[i++] = node.getRootGraphIndex();
        }
        GraphPerspective graphPerspective = network.createGraphPerspective(indices);
        CyNetwork newNetwork = Cytoscape.createNetwork((int[])graphPerspective.getNodeIndicesArray(), (int[])graphPerspective.getEdgeIndicesArray(), (String)("Cluster " + (this.resultViewer.getSelectedNodeSetIndex() + 1)), (CyNetwork)network);
        CyNetworkView newNetworkView = Cytoscape.createNetworkView((CyNetwork)newNetwork);
        newNetworkView.fitContent();
    }
}

