/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.ui.CollapsiblePanel;
import uk.ac.rhul.cs.cl1.ui.ExtendedSpinnerNumberModel;

public class ClusterONEAlgorithmParametersPanel
extends JPanel {
    private static final String AUTO = "Auto";
    protected TreeMap<Section, JPanel> subpanels = null;
    protected TreeMap<Section, TableLayout> layouts = null;
    protected JSpinner minimumClusterSizeSpinner;
    protected JSpinner minimumClusterDensitySpinner;
    protected JSpinner nodePenaltySpinner;
    protected JSpinner haircutThresholdSpinner;
    protected JComboBox mergingMethodCombo;
    protected JSpinner overlapThresholdSpinner;
    protected JComboBox seedMethodCombo;
    protected JComboBox similarityCombo;
    protected String[] mergingMethods = new String[]{"Single-pass", "Multi-pass"};
    protected String[] seedMethods = new String[]{"From unused nodes", "From every node", "From every edge"};
    protected String[] similarityFunctions = new String[]{"Match coefficient", "Simpson coefficient", "Jaccard similarity", "Dice similarity"};
    private final PropertyChangeManager changeManager = new PropertyChangeManager(this);

    public ClusterONEAlgorithmParametersPanel() {
        ClusterONEAlgorithmParameters defaultParams = new ClusterONEAlgorithmParameters();
        this.subpanels = new TreeMap();
        this.layouts = new TreeMap();
        this.setLayout(new BoxLayout(this, 3));
        this.minimumClusterSizeSpinner = this.addSpinner(Section.BASIC, "Minimum size:", new SpinnerNumberModel(defaultParams.getMinSize(), 1, Integer.MAX_VALUE, 1));
        Object minDensity = defaultParams.getMinDensity();
        if (minDensity == null) {
            minDensity = AUTO;
        }
        this.minimumClusterDensitySpinner = this.addSpinner(Section.BASIC, "Minimum density:", new ExtendedSpinnerNumberModel(minDensity, 0.0, 1.0, 0.05, (Object)AUTO));
        ((JSpinner.DefaultEditor)this.minimumClusterDensitySpinner.getEditor()).getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){
            private JFormattedTextField.AbstractFormatter formatter;
            {
                this.formatter = new LenientNumberFormatter();
            }

            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                return this.formatter;
            }
        });
        this.nodePenaltySpinner = this.addSpinner(Section.ADVANCED, "Node penalty:", new SpinnerNumberModel(defaultParams.getNodePenalty(), 0.0, 10.0, 0.2));
        this.haircutThresholdSpinner = this.addSpinner(Section.ADVANCED, "Haircut threshold:", new SpinnerNumberModel(defaultParams.getHaircutThreshold(), 0.0, 1.0, 0.05));
        this.mergingMethodCombo = this.addComboBox(Section.ADVANCED, "Merging method:", this.mergingMethods);
        this.similarityCombo = this.addComboBox(Section.ADVANCED, "Similarity:", this.similarityFunctions);
        this.overlapThresholdSpinner = this.addSpinner(Section.ADVANCED, "Overlap threshold:", new SpinnerNumberModel(defaultParams.getOverlapThreshold(), 0.0, 1.0, 0.05));
        this.seedMethodCombo = this.addComboBox(Section.ADVANCED, "Seeding method:", this.seedMethods);
    }

    public void expandAll() {
        for (JPanel panel : this.subpanels.values()) {
            if (!(panel instanceof CollapsiblePanel)) continue;
            ((CollapsiblePanel)panel).setExpanded(true);
        }
    }

    public ClusterONEAlgorithmParameters getParameters() {
        ClusterONEAlgorithmParameters result;
        block17: {
            block16: {
                result = new ClusterONEAlgorithmParameters();
                Object minimumDensity = this.minimumClusterDensitySpinner.getValue();
                if (minimumDensity.equals(AUTO)) {
                    result.setMinDensity(null);
                } else {
                    result.setMinDensity((Double)minimumDensity);
                }
                result.setMinSize((Integer)this.minimumClusterSizeSpinner.getValue());
                result.setHaircutThreshold((Double)this.haircutThresholdSpinner.getValue());
                result.setOverlapThreshold((Double)this.overlapThresholdSpinner.getValue());
                result.setNodePenalty((Double)this.nodePenaltySpinner.getValue());
                try {
                    if (this.seedMethodCombo.getSelectedIndex() == 0) {
                        result.setSeedGenerator("unused_nodes");
                        break block16;
                    }
                    if (this.seedMethodCombo.getSelectedIndex() == 1) {
                        result.setSeedGenerator("nodes");
                        break block16;
                    }
                    if (this.seedMethodCombo.getSelectedIndex() == 2) {
                        result.setSeedGenerator("edges");
                        break block16;
                    }
                    return null;
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            try {
                if (this.similarityCombo.getSelectedIndex() == 0) {
                    result.setSimilarityFunction("match");
                    break block17;
                }
                if (this.similarityCombo.getSelectedIndex() == 1) {
                    result.setSimilarityFunction("simpson");
                    break block17;
                }
                if (this.similarityCombo.getSelectedIndex() == 2) {
                    result.setSimilarityFunction("jaccard");
                    break block17;
                }
                if (this.similarityCombo.getSelectedIndex() == 3) {
                    result.setSimilarityFunction("dice");
                    break block17;
                }
                return null;
            }
            catch (InstantiationException ex) {
                return null;
            }
        }
        if (this.mergingMethodCombo.getSelectedIndex() == 0) {
            result.setMergingMethodName("single");
        } else if (this.mergingMethodCombo.getSelectedIndex() == 1) {
            result.setMergingMethodName("multi");
        }
        return result;
    }

    public JPanel getSubpanel(Section section) {
        if (this.subpanels.containsKey((Object)section)) {
            return this.subpanels.get((Object)section);
        }
        CollapsiblePanel newPanel = this.constructNewSubpanel(section.getTitle());
        newPanel.setExpanded(section.isExpanded());
        double[][] sizes = new double[][]{{-2.0, 10.0, -2.0}, {-2.0}};
        this.layouts.put(section, new TableLayout(sizes));
        newPanel.setLayout(this.layouts.get((Object)section));
        this.add(newPanel);
        this.add(Box.createVerticalStrut(10));
        this.subpanels.put(section, newPanel);
        return newPanel;
    }

    protected CollapsiblePanel constructNewSubpanel(String title) {
        CollapsiblePanel newPanel = new CollapsiblePanel(title);
        return newPanel;
    }

    public void addComponent(Section section, String caption, Component component) {
        JLabel label = new JLabel(caption);
        JPanel subpanel = this.getSubpanel(section);
        TableLayout layout = this.layouts.get((Object)section);
        int numRows = layout.getNumRow();
        layout.insertRow(numRows, -2.0);
        subpanel.add((Component)label, "0, " + numRows + ", r, c");
        subpanel.add(component, "2, " + numRows + ", l, c");
    }

    public JComboBox addComboBox(Section section, String caption, String[] items) {
        JComboBox<String> combo = new JComboBox<String>(items);
        this.addComponent(section, caption, combo);
        combo.addActionListener(this.changeManager);
        return combo;
    }

    public JSpinner addSpinner(Section section, String caption, SpinnerModel model) {
        JSpinner spinner = new JSpinner();
        spinner.setModel(model);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        editor.getTextField().setColumns(5);
        editor.getTextField().setHorizontalAlignment(4);
        this.addComponent(section, caption, spinner);
        spinner.addChangeListener(this.changeManager);
        return spinner;
    }

    protected void fireParametersChanged() {
        this.firePropertyChange("parameters", null, null);
    }

    public void monitorComponent(Component component) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> cls = component.getClass();
        Method method = null;
        try {
            method = cls.getMethod("addChangeListener", ChangeListener.class);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = cls.getMethod("addActionListener", ActionListener.class);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (method == null) {
            throw new NoSuchMethodException();
        }
        method.invoke((Object)component, this.changeManager);
    }

    private class PropertyChangeManager
    extends PropertyChangeSupport
    implements ActionListener,
    ChangeListener {
        public PropertyChangeManager(Object sourceBean) {
            super(sourceBean);
        }

        public void actionPerformed(ActionEvent event) {
            ClusterONEAlgorithmParametersPanel.this.fireParametersChanged();
        }

        public void stateChanged(ChangeEvent event) {
            ClusterONEAlgorithmParametersPanel.this.fireParametersChanged();
        }
    }

    private class LenientNumberFormatter
    extends JFormattedTextField.AbstractFormatter {
        private DecimalFormat format = new DecimalFormat("0.##");

        private LenientNumberFormatter() {
        }

        public Object stringToValue(String text) throws ParseException {
            try {
                return Double.parseDouble(text);
            }
            catch (NumberFormatException ex) {
                return text;
            }
        }

        public String valueToString(Object value) throws ParseException {
            try {
                return this.format.format(value);
            }
            catch (IllegalArgumentException ex) {
                return value.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Section {
        BASIC("Basic parameters", true),
        ADVANCED("Advanced parameters", false);

        protected String title;
        protected boolean expanded;

        private Section(String title, boolean expanded) {
            this.title = title;
            this.expanded = expanded;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isExpanded() {
            return this.expanded;
        }
    }
}

