/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.seeding.EveryEdgeSeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.EveryNodeSeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.FileBasedSeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.MaximalCliqueSeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.cl1.seeding.StreamBasedSeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.UnusedNodesSeedGenerator;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphAlgorithm;
import uk.ac.rhul.cs.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeedGenerator
extends GraphAlgorithm
implements Iterable<MutableNodeSet>,
Serializable {
    public SeedGenerator() {
        this(null);
    }

    public SeedGenerator(Graph graph) {
        super(graph);
    }

    public abstract int size();

    public abstract SeedIterator iterator();

    public static SeedGenerator fromString(String specification, Graph graph) throws InstantiationException {
        if (specification.equals("nodes")) {
            return new EveryNodeSeedGenerator(graph);
        }
        if (specification.equals("unused_nodes")) {
            return new UnusedNodesSeedGenerator(graph);
        }
        if (specification.equals("edges")) {
            return new EveryEdgeSeedGenerator(graph);
        }
        if (specification.equals("cliques")) {
            return new MaximalCliqueSeedGenerator(graph);
        }
        if (specification.equals("stdin")) {
            return new StreamBasedSeedGenerator(graph, System.in);
        }
        if (specification.startsWith("single(") && specification.endsWith(")")) {
            String seeds = StringUtils.substring(specification, 7, -1);
            StreamBasedSeedGenerator result = new StreamBasedSeedGenerator(graph, new BufferedReader(new StringReader(seeds)));
            result.setDelimiters(", \n\t\r");
            return result;
        }
        if (specification.startsWith("file(") && specification.endsWith(")")) {
            String filename = StringUtils.substring(specification, 5, -1);
            try {
                return new FileBasedSeedGenerator(graph, filename);
            }
            catch (FileNotFoundException ex) {
                throw new InstantiationException("file not found: " + filename);
            }
            catch (IOException ex) {
                throw new InstantiationException("IO error while reading file: " + filename);
            }
        }
        throw new InstantiationException("unknown seed generator type: " + specification);
    }

    public static SeedGenerator fromString(String specification) throws InstantiationException {
        return SeedGenerator.fromString(specification, null);
    }
}

