/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.filters;

import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.filters.NodeSetFilter;

public class DensityFilter
implements NodeSetFilter {
    protected double minDensity;
    protected double maxDensity;

    public DensityFilter() {
        this(0.0, Double.MAX_VALUE);
    }

    public DensityFilter(double minDensity) {
        this(minDensity, Double.MAX_VALUE);
    }

    public DensityFilter(double minDensity, double maxDensity) {
        this.minDensity = minDensity;
        this.maxDensity = maxDensity;
    }

    public boolean filter(MutableNodeSet nodeSet) {
        double density = nodeSet.getDensity();
        return density >= this.minDensity && density <= this.maxDensity;
    }

    public double getMinDensity() {
        return this.minDensity;
    }

    public double getMaxDensity() {
        return this.maxDensity;
    }

    public void setMinDensity(double minDensity) {
        this.minDensity = minDensity;
    }

    public void setMaxDensity(double maxDensity) {
        this.maxDensity = maxDensity;
    }
}

