% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Analysis.R
\name{plot_RLum.Analysis}
\alias{plot_RLum.Analysis}
\title{Plot function for an RLum.Analysis S4 class object}
\usage{
plot_RLum.Analysis(
  object,
  subset = NULL,
  nrows,
  ncols,
  abline = NULL,
  combine = FALSE,
  records_max = NULL,
  curve.transformation = "None",
  plot_singlePanels = FALSE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} (\strong{required}):
S4 object of class \code{RLum.Analysis}}

\item{subset}{named \link{list} (\emph{optional}):
subsets elements for plotting. The arguments in the named \link{list} will be
directly passed to the function \link{get_RLum}
(e.g., \code{subset = list(curveType = "measured")})}

\item{nrows}{\link{integer} (\emph{optional}):
sets number of rows for plot output, if nothing is set the function
tries to find a value.}

\item{ncols}{\link{integer} (\emph{optional}):
sets number of columns for plot output, if nothing is set the function
tries to find a value.}

\item{abline}{\link{list} (\emph{optional}):
allows to add ab-lines to the plot. Argument are provided
in a list and will be forward to the function \link{abline},
e.g., \code{list(v = c(10, 100))} adds two vertical lines add 10 and 100 to all
plots. In contrast \verb{list(v = c(10), v = c(100)} adds a vertical at 10 to
the first and a vertical line at 100 to the 2nd plot.}

\item{combine}{\link{logical} (\emph{with default}):
allows to combine all \linkS4class{RLum.Data.Curve} objects in one single plot.}

\item{records_max}{\link{numeric} (\emph{optional}): limits number of records
shown if \code{combine = TRUE}. Shown are always the first and the last curve,
the other number of curves to be shown a distributed evenly, this may result
in fewer curves plotted as specified. This parameter has only
an effect for  n > 2.}

\item{curve.transformation}{\link{character} (\emph{with default}):
allows transforming CW-OSL and CW-IRSL curves to pseudo-LM curves via
transformation functions. Allowed values are: \code{CW2pLM}, \code{CW2pLMi},
\code{CW2pHMi} and \code{CW2pPMi}, see details. If set to \code{None} (default), no
transformation is applied.}

\item{plot_singlePanels}{\link{logical} (\emph{with default}):
global par settings are considered, normally this should end in one plot per page}

\item{...}{further arguments and graphical parameters will be passed to
the \code{plot} function.

Supported arguments: \code{main}, \code{mtext}, \code{log}, \code{lwd}, \code{lty} \code{type}, \code{pch}, \code{col},
\code{norm} (see \link{plot_RLum.Data.Curve}), \code{xlim},\code{ylim}, \code{xlab}, \code{ylab}, ...

and for \code{combine = TRUE} also: \code{sub_title}, \code{legend}, \code{legend.text}, \code{legend.pos}
(typical plus 'outside'), \code{legend.col}, \code{smooth}.

All arguments can be provided as \code{vector} or \code{list} to gain in full control
of all plot settings.}
}
\value{
Returns multiple plots.
}
\description{
The function provides a standardised plot output for curve data of an
RLum.Analysis S4 class object

The function produces a multiple plot output. A file output is recommended
(e.g., \link{pdf}).

\strong{curve.transformation}

This argument allows transforming continuous wave (CW) curves to pseudo
(linear) modulated curves. For the transformation, the functions of the
package are used. Currently, it is not possible to pass further arguments to
the transformation functions. The argument works only for \code{ltype}
\code{OSL} and \code{IRSL}.

Please note: The curve transformation within this functions works roughly,
i.e. every IRSL or OSL curve is transformed, without considering whether it
is measured with the PMT or not! However, for a fast look it might be
helpful.
}
\note{
Not all arguments available for \link{plot} will be passed and they partly do not behave in the
way you might expect them to work. This function was designed to serve as an overview
plot, if you want to have more control, extract the objects and plot them individually.
}
\section{Function version}{
 0.3.16
}

\examples{

##load data
data(ExampleData.BINfileData, envir = environment())

##convert values for position 1
temp <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)

##(1) plot (combine) TL curves in one plot
plot_RLum.Analysis(
temp,
subset = list(recordType = "TL"),
combine = TRUE,
norm = TRUE,
abline = list(v = c(110))
)

##(2) same as example (1) but using
## the argument smooth = TRUE
plot_RLum.Analysis(
temp,
subset = list(recordType = "TL"),
combine = TRUE,
norm = TRUE,
smooth = TRUE,
abline = list(v = c(110))
)

}
\seealso{
\link{plot}, \link{plot_RLum}, \link{plot_RLum.Data.Curve}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. plot_RLum.Analysis(): Plot function for an RLum.Analysis S4 class object. Function version 0.3.16. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.0. https://r-lum.github.io/Luminescence/
}

\keyword{aplot}
