% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_Concentration2DoseRate.R
\name{convert_Concentration2DoseRate}
\alias{convert_Concentration2DoseRate}
\title{Dose-rate conversion function}
\usage{
convert_Concentration2DoseRate(input, conversion = "Guerinetal2011")
}
\arguments{
\item{input}{\link{data.frame} (\emph{optional}): a table containing all relevant information
for each individual layer if nothing is provided, the function returns a template \link{data.frame}
Please note that until one dataset per input is supported!}

\item{conversion}{\link{character} (\emph{with default}): which dose rate conversion factors to use,
defaults uses Guérin et al. (2011). For accepted values see \link{BaseDataSet.ConversionFactors}}
}
\value{
The function returns an \linkS4class{RLum.Results} object for which the first
element is \link{matrix} with the converted values. If no input is provided, the
function returns a template \link{data.frame} that can be used as input.
}
\description{
This function converts radionuclide concentrations
(K in \%, Th and U in ppm) into dose rates (Gy/ka). Beta-dose rates are also
attenuated for the grain size. Beta and gamma-dose rates are corrected
for the water content. This function converts concentrations into dose rates
(Gy/ka) and corrects for grain size attenuation and water content

Dose rate conversion factors can be chosen from Adamiec and Aitken (1998),
Guerin et al. (2011), Liritzis et al. (201) and Cresswell et al. (2018).
Default is Guerin et al. (2011).

Grain size correction for beta dose rates is achieved using the correction
factors published by Guérin et al. (2012).

Water content correction is based on factors provided by Aitken (1985),
with the factor for beta dose rate being 1.25 and for gamma 1.14.
}
\details{
\strong{The input data}

\tabular{lll}{
COLUMN \tab DATA TYPE \tab DESCRIPTION\cr
\code{Mineral} \tab \code{character} \tab \code{'FS'} for feldspar, \code{'Q'} for quartz\cr
\code{K} \tab \code{numeric} \tab K nuclide content in \%\cr
\code{K_SE} \tab \code{numeric} \tab error on K nuclide content in \%\cr
\code{Th} \tab \code{numeric} \tab Th nuclide content in ppm\cr
\code{Th_SE} \tab \code{numeric} error on Th nuclide content in ppm\cr
\code{U} \tab \code{numeric} U nuclide content in ppm\cr
\code{U_SE} \tab \code{numeric} \tab error on U nuclide content in ppm\cr
\code{GrainSize} \tab \code{numeric} \tab average grain size in µm\cr
\code{WaterContent} \tab \code{numeric} \tab mean water content in \%\cr
\code{WaterContent_SE} \tab \code{numeric} \tab relative error on water content
}

\strong{Water content}
The water content provided by the user should be calculated according to:

\deqn{(Wet_weight - Dry_weight) / Dry_weight * 100}

The unit for the weight is gram (g).
}
\section{Function version}{
 0.1.0
}

\examples{

## create input template
input <- convert_Concentration2DoseRate()

## fill input
input$Mineral <- "FS"
input$K <- 2.13
input$K_SE <- 0.07
input$Th <- 9.76
input$Th_SE <- 0.32
input$U <- 2.24
input$U_SE <- 0.12
input$GrainSize <- 200
input$WaterContent <- 30
input$WaterContent_SE <- 5

## convert
convert_Concentration2DoseRate(input)

} 

\section{How to cite}{
Riedesel, S., Autzen, M., 2024. convert_Concentration2DoseRate(): Dose-rate conversion function. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.24. https://CRAN.R-project.org/package=Luminescence
}

\references{
Adamiec, G., Aitken, M.J., 1998. Dose-rate conversion factors: update. Ancient TL 16, 37-46.

Cresswell., A.J., Carter, J., Sanderson, D.C.W., 2018. Dose rate conversion parameters:
Assessment of nuclear data. Radiation Measurements 120, 195-201.

Guerin, G., Mercier, N., Adamiec, G., 2011. Dose-rate conversion factors: update.
Ancient TL, 29, 5-8.

Guerin, G., Mercier, N., Nathan, R., Adamiec, G., Lefrais, Y., 2012. On the use
of the infinite matrix assumption and associated concepts: A critical review.
Radiation Measurements, 47, 778-785.

Liritzis, I., Stamoulis, K., Papachristodoulou, C., Ioannides, K., 2013.
A re-evaluation of radiation dose-rate conversion factors. Mediterranean
Archaeology and Archaeometry 13, 1-15.
}
\author{
Svenja Riedesel, Aberystwyth University (United Kingdom) \cr
Martin Autzen, DTU NUTECH Center for Nuclear Technologies (Denmark)
, RLum Developer Team}
\keyword{datagen}
