% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Spectrum.R
\name{plot_RLum.Data.Spectrum}
\alias{plot_RLum.Data.Spectrum}
\title{Plot function for an RLum.Data.Spectrum S4 class object}
\usage{
plot_RLum.Data.Spectrum(
  object,
  par.local = TRUE,
  plot.type = "contour",
  optical.wavelength.colours = TRUE,
  bg.spectrum = NULL,
  bg.channels = NULL,
  bin.rows = 1,
  bin.cols = 1,
  norm = NULL,
  rug = TRUE,
  limit_counts = NULL,
  xaxis.energy = FALSE,
  legend.text,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Spectrum} or \link{matrix} (\strong{required}):
S4 object of class \code{RLum.Data.Spectrum} or a \code{matrix} containing count
values of the spectrum.\cr
Please note that in case of a matrix row names and col names are set
automatically if not provided.}

\item{par.local}{\link{logical} (\emph{with default}):
use local graphical parameters for plotting, e.g. the plot is shown in one column and one row.
If \code{par.local = FALSE} global parameters are inherited.}

\item{plot.type}{\link{character} (\emph{with default}): plot type, for
3D-plot use \code{persp}, or \code{interactive}, for a 2D-plot \code{image}, \code{contour},
\code{single} or \code{multiple.lines} (along the time or temperature axis)
or \code{transect} (along the wavelength axis) \cr}

\item{optical.wavelength.colours}{\link{logical} (\emph{with default}):
use optical wavelength colour palette. Note: For this, the spectrum range is
limited: \code{c(350,750)}. Own colours can be set with the argument \code{col}. If you provide already
binned spectra, the colour assignment is likely to be wrong, since the colour gradients are calculated
using the bin number.}

\item{bg.spectrum}{\linkS4class{RLum.Data.Spectrum} or \link{matrix} (\emph{optional}): Spectrum
used for the background subtraction. By definition, the background spectrum should have been
measured with the same setting as the signal spectrum. If a spectrum is provided, the
argument \code{bg.channels} works only on the provided background spectrum.}

\item{bg.channels}{\link{vector} (\emph{optional}):
defines channel for background subtraction If a vector is provided the mean
of the channels is used for subtraction. If a spectrum is provided via \code{bg.spectrum}, this
argument only works on the \code{bg.spectrum}.

\strong{Note:} Background subtraction is applied prior to channel binning}

\item{bin.rows}{\link{integer} (\emph{with default}):
allow summing-up wavelength channels (horizontal binning),
e.g. \code{bin.rows = 2} two channels are summed up.
Binning is applied after the background subtraction.}

\item{bin.cols}{\link{integer} (\emph{with default}):
allow summing-up channel counts (vertical binning) for plotting,
e.g. \code{bin.cols = 2} two channels are summed up.
Binning is applied after the background subtraction.}

\item{norm}{\link{character} (\emph{optional}): Normalise data to the maximum (\code{norm = "max"}) or
minimum (\code{norm = "min"}) count values. The normalisation is applied after the binning.}

\item{rug}{\link{logical} (\emph{with default}):
enables or disables colour rug. Currently only implemented for plot
type \code{multiple.lines} and \code{single}}

\item{limit_counts}{\link{numeric} (\emph{optional}):
value to limit all count values to this value, i.e. all count values above
this threshold will be replaced by this threshold. This is helpful
especially in case of TL-spectra.}

\item{xaxis.energy}{\link{logical} (\emph{with default}): enables or disables energy instead of
wavelength axis. For the conversion the function \link{convert_Wavelength2Energy} is used.

\strong{Note:} This option means not only simply redrawing the axis,
instead the spectrum in terms of intensity is recalculated, s. details.}

\item{legend.text}{\link{character} (\emph{with default}):
possibility to provide own legend text. This argument is only considered for
plot types providing a legend, e.g. \code{plot.type="transect"}}

\item{...}{further arguments and graphical parameters that will be passed
to the \code{plot} function.}
}
\value{
Returns a plot.
}
\description{
The function provides a standardised plot output for spectrum data of an
\linkS4class{RLum.Data.Spectrum} class object. The purpose of this function is to provide
easy and straight-forward spectra plotting, not provide a full customised access to
all plot parameters. If this is wanted, standard R plot functionality should be used
instead.

\strong{Matrix structure} \cr (cf. \linkS4class{RLum.Data.Spectrum})
\itemize{
\item \code{rows} (x-values): wavelengths/channels (\code{xlim}, \code{xlab})
\item \code{columns} (y-values): time/temperature (\code{ylim}, \code{ylab})
\item \code{cells} (z-values): count values (\code{zlim}, \code{zlab})
}

\emph{Note: This nomenclature is valid for all plot types of this function!}

\strong{Nomenclature for value limiting}
\itemize{
\item \code{xlim}: Limits values along the wavelength axis
\item \code{ylim}: Limits values along the time/temperature axis
\item \code{zlim}: Limits values along the count value axis
}

\strong{Details on the plot functions}

Spectrum is visualised as 3D or 2D plot. Both plot types are based on
internal R plot functions.

\strong{\code{plot.type = "persp"}}

Arguments that will be passed to \link[graphics:persp]{graphics::persp}:
\itemize{
\item \code{shade}: default is \code{0.4}
\item \code{phi}: default is \code{15}
\item \code{theta}: default is \code{-30}
\item \code{expand}: default is \code{1}
\item \code{ticktype}: default is \code{detailed}, \code{r}: default is \code{10}
}

\strong{Note:} Further parameters can be adjusted via \code{par}. For example
to set the background transparent and reduce the thickness of the lines use:
\code{par(bg = NA, lwd = 0.7)} previous the function call.

\strong{\code{plot.type = "single"}}

Per frame a single curve is returned. Frames are time or temperature
steps.

\strong{\code{plot.type = "multiple.lines"}}

All frames plotted in one frame.

'**\code{plot.type = "image"} or `plot.type = "contour" **

These plot types use the R functions \link[graphics:image]{graphics::image} or \link[graphics:contour]{graphics::contour}.
The advantage is that many plots can be arranged conveniently using standard
R plot functionality. If \code{plot.type = "image"} a contour is added by default,
which can be disabled using the argument \code{contour = FALSE} to add own contour
lines of choice.

\strong{\code{plot.type = "transect"}}

Depending on the selected wavelength/channel range a transect over the
time/temperature (y-axis) will be plotted along the wavelength/channels
(x-axis). If the range contains more than one channel, values (z-values) are
summed up. To select a transect use the \code{xlim} argument, e.g.
\code{xlim = c(300,310)} plot along the summed up count values of channel
300 to 310.

\strong{Further arguments that will be passed (depending on the plot type)}

\code{xlab}, \code{ylab}, \code{zlab}, \code{xlim}, \code{ylim},
\code{zlim}, \code{main}, \code{mtext}, \code{pch}, \code{type} (\code{"single"}, \code{"multiple.lines"}, \code{"interactive"}),
\code{col}, \code{border}, \code{box} \code{lwd}, \code{bty}, \code{showscale} (\code{"interactive"}, \code{"image"})
\code{contour}, \code{contour.col} (\code{"image"})
}
\note{
Not all additional arguments (\code{...}) will be passed similarly!
}
\section{Function version}{
 0.6.3
}

\examples{

##load example data
data(ExampleData.XSYG, envir = environment())

##(1)plot simple spectrum (2D) - image
plot_RLum.Data.Spectrum(
 TL.Spectrum,
 plot.type="image",
 xlim = c(310,750),
 ylim = c(0,300),
 bin.rows=10,
 bin.cols = 1)

##(2) plot spectrum (3D)
plot_RLum.Data.Spectrum(
  TL.Spectrum,
  plot.type="persp",
  xlim = c(310,750),
  ylim = c(0,100),
  bin.rows=10,
  bin.cols = 1)

##(3) plot spectrum on energy axis
##please note the background subtraction
plot_RLum.Data.Spectrum(TL.Spectrum,
plot.type="persp",
ylim = c(0,200),
bin.rows=10,
bg.channels = 10,
bin.cols = 1,
xaxis.energy = TRUE)

##(4) plot multiple lines (2D) - multiple.lines (with ylim)
plot_RLum.Data.Spectrum(
 TL.Spectrum,
 plot.type="multiple.lines",
 xlim = c(310,750),
 ylim = c(0,100),
 bin.rows=10,
 bin.cols = 1)

\dontrun{
 ##(4) interactive plot using the package plotly ("surface")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1)

 ##(5) interactive plot using the package plotly ("contour")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1,
 type = "contour",
 showscale = TRUE)

 ##(6) interactive plot using the package plotly ("heatmap")
 plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="interactive",
 xlim = c(310,750), ylim = c(0,300), bin.rows=10,
 bin.cols = 1,
 type = "heatmap",
 showscale = TRUE)

}

}
\seealso{
\linkS4class{RLum.Data.Spectrum}, \link{convert_Wavelength2Energy}, \link{plot}, \link{plot_RLum}, \link[graphics:persp]{graphics::persp}, \link[plotly:plot_ly]{plotly::plot_ly}, \link[graphics:contour]{graphics::contour}, \link[graphics:image]{graphics::image}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2021. plot_RLum.Data.Spectrum(): Plot function for an RLum.Data.Spectrum S4 class object. Function version 0.6.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.16. https://CRAN.R-project.org/package=Luminescence
}

\keyword{aplot}
