% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trans_to_microeco.R
\name{Trans_to_microeco}
\alias{Trans_to_microeco}
\title{Convert a LorMe object to a microeco object}
\usage{
Trans_to_microeco(taxobj, use_reads = TRUE)
}
\arguments{
\item{taxobj}{A \code{\link{LorMe}} object (usually generated by \code{tax_summary} ).}

\item{use_reads}{Logical. \code{FALSE} (default) uses \strong{relative abundance} (\code{Base_percent}); \code{TRUE} uses \strong{raw counts}
(\code{Base}).}
}
\value{
A \code{\link[microeco:microtable]{microtable}} object.
}
\description{
Convert a LorMe object to a microeco object
}
\examples{
\dontrun{
data("Two_group")

Two_group_microeco=Trans_to_microeco(Two_group)

t1 <- trans_abund$new(dataset = Two_group_microeco, taxrank = "Phylum", ntaxa = 10)
t1$plot_bar(others_color = "grey70",
            legend_text_italic = FALSE) +
            theme(axis.title.y = element_text(size = 18)) #Just to show it can be used for analysis
}
}
