% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Lebron}
\alias{Lebron}
\title{Lebron—A logistic data set, with the result indicating whether or not Lebron scored on each shot in the data set.}
\format{
An object of class \code{data.frame} with 1533 rows and 12 columns.
}
\usage{
Lebron
}
\description{
This dataset opens the door to the intricacies of the 2023 NBA season, offering a profound understanding of the art of scoring in professional basketball.
}
\details{
\describe{
 \item{top}{The vertical position on the court where the shot was taken}
 \item{left}{The horizontal position on the court where the shot was taken}
 \item{date}{The date when the shot was taken. (e.g., Oct 18, 2022)}
 \item{qtr}{The quarter in which the shot was attempted, typically represented as "1st Qtr," "2nd Qtr," etc.}
 \item{time_remaining}{The time remaining in the quarter when the shot was attempted, typically displayed as minutes and seconds (e.g., 09:26).}
 \item{result}{Indicates whether the shot was successful, with "TRUE" for a made shot and "FALSE" for a missed shot}
 \item{shot_type}{Describes the type of shot attempted, such as a "2" for a two-point shot or "3" for a three-point shot}
 \item{distance_ft}{The distance in feet from the hoop to where the shot was taken}
 \item{lead}{Indicates whether the team was leading when the shot was attempted, with "TRUE" for a lead and "FALSE" for no lead}
 \item{lebron_team_score}{The team's score (in points) when the shot was taken}
 \item{opponent_team_score}{The opposing team's score (in points) when the shot was taken}
 \item{opponent}{The abbreviation for the opposing team (e.g., GSW for Golden State Warriors)}
 \item{team}{The abbreviation for LeBron James's team (e.g., LAL for Los Angeles Lakers)}
 \item{season}{The season in which the shots were taken, indicated as the year (e.g., 2023)}
 \item{color}{Represents the color code associated with the shot, which may indicate shot outcomes or other characteristics (e.g., "red" or "green")}
 }

 @source <https://www.kaggle.com/datasets/dhavalrupapara/nba-2023-player-shot-dataset>
}
\keyword{datasets}
