% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idPOS.R
\name{idPOS}
\alias{idPOS}
\title{Lipids annotation for ESI+}
\usage{
idPOS(MS1, MSMS1, MSMS2 = data.frame(), ppm_precursor = 10,
  ppm_products = 10, rttol = 3)
}
\arguments{
\item{MS1}{data frame cointaining all peaks from the full MS function. It
must have three columns: m.z, RT (in seconds) and int (intensity).}

\item{MSMS1}{data frame cointaining all peaks from the low energy function.
It must have three columns: m.z, RT and int.}

\item{MSMS2}{data frame cointaining all peaks from the high energy
function if it is the case. It must have three columns: m.z, RT and int.
Optional.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}
}
\value{
The output is a list with 2 elements: 1) a data frame that shows: ID,
class of lipid, CDB (total number of carbons and double bounds), FA
composition (specific chains composition if it has been confirmed), mz, RT
(in seconds), I (intensity, which comes directly from de input), Adducts,
ppm (m.z error), confidenceLevel (Subclass, FA level, where chains are known
but not their positions, or FA position level); and 2) the original MS1
peaklist with the annotations on it.
}
\description{
Lipids annotation based on fragmentation patterns for LC-MS/MS all-ions data
acquired in positive mode. This function compiles all functions writen for
ESI+ annotations.
}
\examples{
\donttest{idPOS(MS1 = LipidMS::serum_pos_fullMS, MSMS1 = LipidMS::serum_pos_Ce20,
MSMS2 = LipidMS::serum_pos_Ce40)}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
