% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessing.R
\name{dataProcessing}
\alias{dataProcessing}
\title{Process mzXML files: peakpicking and deisotoping}
\usage{
dataProcessing(file, msLevel, polarity, dmzgap = 50, drtgap = 25,
  ppm = TRUE, minpeak, maxint = 1e+09, dmzdens, drtdens = 20,
  merged = FALSE, drtsmall, drtfill = 20, drttotal = 200, recurs = 4,
  weight, SB, SN = 2, minint, ended = 2, progbar = FALSE, from = FALSE,
  to = FALSE)
}
\arguments{
\item{file}{path of the mzXML input file}

\item{msLevel}{numeric value indicating if data belongs to level 1 (fullMS)
or level 2 (MS/MS)}

\item{polarity}{character value: negative or positive}

\item{dmzgap}{enviPick parameter. 50 by default.}

\item{drtgap}{enviPick parameter. 25 by default.}

\item{ppm}{enviPick parameter. TRUE by default.}

\item{minpeak}{enviPick parameter. Optional. By default, 5 when msLevel = 1
and 4 when msLevel = 2.}

\item{maxint}{enviPick parameter. 1E9 by default.}

\item{dmzdens}{enviPick parameter. Optional. By default, 15 when msLevel = 1
and 20 when msLevel = 2.}

\item{drtdens}{enviPick parameter. Optional. 20 by default.}

\item{merged}{enviPick parameter. FALSE by default.}

\item{drtsmall}{enviPick parameter. Optional. By default, 100 when
msLevel = 1 and 20 when msLevel = 2.}

\item{drtfill}{enviPick parameter. 20 by default.}

\item{drttotal}{enviPick parameter. 200 by default.}

\item{recurs}{enviPick parameter. 4 by default.}

\item{weight}{enviPick parameter. Optional. By default, 1 when msLevel = 1
and 2 when msLevel = 2.}

\item{SB}{enviPick parameter. Optional. By default, 3 when msLevel = 1
and 2 when msLevel = 2.}

\item{SN}{enviPick parameter. 2 by default.}

\item{minint}{enviPick parameter. Optional. By default, 1000 when msLevel = 1
and 100 when msLevel = 2.}

\item{ended}{enviPick parameter. 2 by default.}

\item{progbar}{enviPick parameter. FALSE by default.}

\item{from}{enviPick parameter. FALSE by default.}

\item{to}{enviPick parameter. FALSE by default.}
}
\value{
Data frame with 3 columns (m.z, RT and int) containing the peaklist.
}
\description{
Process mzXML files: peak-picking using enviPick and deisotoping
using CAMERA.
}
\details{
This function executes 2 steps: 1) peak-picking using enviPick
package and 2) it removes isotopes using CAMERA. If msLevel = 1, only ions
with more than 1 isotope are kept.
}
\examples{

\donttest{
dataProcessing("input_file.mzXML", msLevel = 1, polarity = "positive")
}

}
\references{
https://cran.r-project.org/web/packages/enviPick/index.html

Kuhl C, Tautenhahn R, Boettcher C, Larson TR ans Neumann S (2012). "CAMERA:
an integrated strategy for compound spectra extraction and annotation of
liquid chromatography-mass spectrometry data sets." Analytical Chemistry, 84,
pp. 283-289. htto://pubs.acs.org/doi/abs/10.1021/ac202450g.
}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
