% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc_AccountSummary.R
\name{lc_AccountSummary}
\alias{lc_AccountSummary}
\title{Return the investor's Account Summary}
\usage{
lc_AccountSummary(LC_CRED = NULL)
}
\arguments{
\item{LC_CRED}{Credential object having class LendingClub_credential. This object can be created using the \code{lc_MakeCredential()} function. You can pass the object directly as an argument to the function or alternatively, it can be read from the global environment if it was stored as "LC_CRED".}
}
\value{
Object of class LendingClub_api. The object has two components. The first is \code{$content} with a data.frame of attributes of the invenstor's account such as available cash and value of the portfolios. The data arranged as a 1 row data.frame with an attribute in each column.  The second component is the \code{$response} including a timestamp of when the data was retrieved.
}
\description{
Access the user's account and return the summary data.  The data points
include available cash, total account balance, and the number of notes in the
account
}
\examples{
\dontrun{
LC_CRED<- lc_MakeCredential(InvestorID, APIKey)
lc_AccountSummary()}

}
