% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordinateImage.R
\name{CoordinateImage}
\alias{CoordinateImage}
\title{Plots a coordinate (cartesian) plane with customizable limits for the X and Y axis over a background image}
\usage{
CoordinateImage(x_min, x_max, y_min, y_max, image)
}
\arguments{
\item{x_min}{Lowest value for the X axis}

\item{x_max}{Highest value for the X axis}

\item{y_min}{Lowest value for the Y axis}

\item{y_max}{Highest value for the Y axis}

\item{image}{Raster object (bitmap image). This image can be loaded in R with function \code{readPNG} (png package) or \code{readJPEG} (jpeg package). It is also possible to obtain aerial images from Google Maps with the aid of RgoogleMaps package (as in the following example)}
}
\value{
None. It produces a plot of a coordinate plane over a background image. It allows the user to use the functions of the package over a real and physical object
}
\description{
\code{CoordinateImage} plots a coordinate (cartesian) plane with customizable limits for the X and Y axis over a background image
}
\examples{
library(RgoogleMaps)
ima=GetMap("Plaza de San Pedro, Roma", zoom = 17, maptype = "satellite")
ima=ima$myTile
CoordinateImage(-6, 6, -6, 6, ima) 
Draw(CreateArcAngles(c(0.8411822, 0), 1.5, 0, 360), "white")
Draw(CreateLinePoints(c(0.8411822, 0), c(1.880481, 1.087281)), "white")
Draw(CreateLinePoints(c(0.8411822, 0), c(1.89672, -0.9488258)), "white")
}
